// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TensorPluginInfo.C
// ****************************************************************************

#include <TensorPluginInfo.h>
#include <TensorAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Tensor,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Tensor,General)

// ****************************************************************************
//  Method: TensorGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TensorGeneralPluginInfo::GetName() const
{
    return "Tensor";
}

// ****************************************************************************
//  Method: TensorGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TensorGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: TensorGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TensorGeneralPluginInfo::GetID() const
{
    return "Tensor_1.0";
}
// ****************************************************************************
//  Method: TensorGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
TensorGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
