// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyTensorAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyTensorAttributes
//
// Purpose:
//   Attributes for the tensor plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a TensorAttributes.
//
struct TensorAttributesObject
{
    PyObject_HEAD
    TensorAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewTensorAttributes(int);

std::string
PyTensorAttributes_ToString(const TensorAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *glyphLocation_names = "AdaptsToMeshResolution, UniformInSpace";
    switch (atts->GetGlyphLocation())
    {
      case TensorAttributes::AdaptsToMeshResolution:
          snprintf(tmpStr, 1000, "%sglyphLocation = %sAdaptsToMeshResolution  # %s\n", prefix, prefix, glyphLocation_names);
          str += tmpStr;
          break;
      case TensorAttributes::UniformInSpace:
          snprintf(tmpStr, 1000, "%sglyphLocation = %sUniformInSpace  # %s\n", prefix, prefix, glyphLocation_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetUseStride())
        snprintf(tmpStr, 1000, "%suseStride = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%suseStride = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%snTensors = %d\n", prefix, atts->GetNTensors());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sstride = %d\n", prefix, atts->GetStride());
    str += tmpStr;
    if(atts->GetOrigOnly())
        snprintf(tmpStr, 1000, "%sorigOnly = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sorigOnly = 0\n", prefix);
    str += tmpStr;
    const char *limitsMode_names = "OriginalData, CurrentPlot";
    switch (atts->GetLimitsMode())
    {
      case TensorAttributes::OriginalData:
          snprintf(tmpStr, 1000, "%slimitsMode = %sOriginalData  # %s\n", prefix, prefix, limitsMode_names);
          str += tmpStr;
          break;
      case TensorAttributes::CurrentPlot:
          snprintf(tmpStr, 1000, "%slimitsMode = %sCurrentPlot  # %s\n", prefix, prefix, limitsMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetMinFlag())
        snprintf(tmpStr, 1000, "%sminFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sminFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smin = %g\n", prefix, atts->GetMin());
    str += tmpStr;
    if(atts->GetMaxFlag())
        snprintf(tmpStr, 1000, "%smaxFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%smaxFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smax = %g\n", prefix, atts->GetMax());
    str += tmpStr;
    if(atts->GetColorByEigenValues())
        snprintf(tmpStr, 1000, "%scolorByEigenValues = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%scolorByEigenValues = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    if(atts->GetInvertColorTable())
        snprintf(tmpStr, 1000, "%sinvertColorTable = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sinvertColorTable = 0\n", prefix);
    str += tmpStr;
    const unsigned char *tensorColor = atts->GetTensorColor().GetColor();
    snprintf(tmpStr, 1000, "%stensorColor = (%d, %d, %d, %d)\n", prefix, int(tensorColor[0]), int(tensorColor[1]), int(tensorColor[2]), int(tensorColor[3]));
    str += tmpStr;
    if(atts->GetUseLegend())
        snprintf(tmpStr, 1000, "%suseLegend = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%suseLegend = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sscale = %g\n", prefix, atts->GetScale());
    str += tmpStr;
    if(atts->GetScaleByMagnitude())
        snprintf(tmpStr, 1000, "%sscaleByMagnitude = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sscaleByMagnitude = 0\n", prefix);
    str += tmpStr;
    if(atts->GetAutoScale())
        snprintf(tmpStr, 1000, "%sautoScale = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sautoScale = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sanimationStep = %d\n", prefix, atts->GetAnimationStep());
    str += tmpStr;
    return str;
}

static PyObject *
TensorAttributes_Notify(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_SetGlyphLocation(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the glyphLocation in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetGlyphLocation(TensorAttributes::GlyphLocation(ival));
    else
    {
        fprintf(stderr, "An invalid glyphLocation value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "AdaptsToMeshResolution, UniformInSpace.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetGlyphLocation(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGlyphLocation()));
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetUseStride(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useStride in the object.
    obj->data->SetUseStride(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetUseStride(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseStride()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetNTensors(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nTensors in the object.
    obj->data->SetNTensors((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetNTensors(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNTensors()));
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetStride(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stride in the object.
    obj->data->SetStride((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetStride(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStride()));
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetOrigOnly(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the origOnly in the object.
    obj->data->SetOrigOnly(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetOrigOnly(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOrigOnly()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetLimitsMode(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitsMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetLimitsMode(TensorAttributes::LimitsMode(ival));
    else
    {
        fprintf(stderr, "An invalid limitsMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "OriginalData, CurrentPlot.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetLimitsMode(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLimitsMode()));
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetMin(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetMin(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetMax(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetMax(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetColorByEigenValues(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorByEigenValues in the object.
    obj->data->SetColorByEigenValues(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetColorByEigenValues(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetColorByEigenValues()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetInvertColorTable(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the invertColorTable in the object.
    obj->data->SetInvertColorTable(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetInvertColorTable(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInvertColorTable()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetTensorColor(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the tensorColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetTensorColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetTensorColor(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the tensorColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *tensorColor = obj->data->GetTensorColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(tensorColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(tensorColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(tensorColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(tensorColor[3])));
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetUseLegend(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useLegend in the object.
    obj->data->SetUseLegend(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetUseLegend(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseLegend()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetScale(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the scale in the object.
    obj->data->SetScale(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetScale(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetScale());
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetScaleByMagnitude(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaleByMagnitude in the object.
    obj->data->SetScaleByMagnitude(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetScaleByMagnitude(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetScaleByMagnitude()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetAutoScale(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the autoScale in the object.
    obj->data->SetAutoScale(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetAutoScale(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAutoScale()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TensorAttributes_SetAnimationStep(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the animationStep in the object.
    obj->data->SetAnimationStep((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TensorAttributes_GetAnimationStep(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAnimationStep()));
    return retval;
}



PyMethodDef PyTensorAttributes_methods[TENSORATTRIBUTES_NMETH] = {
    {"Notify", TensorAttributes_Notify, METH_VARARGS},
    {"SetGlyphLocation", TensorAttributes_SetGlyphLocation, METH_VARARGS},
    {"GetGlyphLocation", TensorAttributes_GetGlyphLocation, METH_VARARGS},
    {"SetUseStride", TensorAttributes_SetUseStride, METH_VARARGS},
    {"GetUseStride", TensorAttributes_GetUseStride, METH_VARARGS},
    {"SetNTensors", TensorAttributes_SetNTensors, METH_VARARGS},
    {"GetNTensors", TensorAttributes_GetNTensors, METH_VARARGS},
    {"SetStride", TensorAttributes_SetStride, METH_VARARGS},
    {"GetStride", TensorAttributes_GetStride, METH_VARARGS},
    {"SetOrigOnly", TensorAttributes_SetOrigOnly, METH_VARARGS},
    {"GetOrigOnly", TensorAttributes_GetOrigOnly, METH_VARARGS},
    {"SetLimitsMode", TensorAttributes_SetLimitsMode, METH_VARARGS},
    {"GetLimitsMode", TensorAttributes_GetLimitsMode, METH_VARARGS},
    {"SetMinFlag", TensorAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", TensorAttributes_GetMinFlag, METH_VARARGS},
    {"SetMin", TensorAttributes_SetMin, METH_VARARGS},
    {"GetMin", TensorAttributes_GetMin, METH_VARARGS},
    {"SetMaxFlag", TensorAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", TensorAttributes_GetMaxFlag, METH_VARARGS},
    {"SetMax", TensorAttributes_SetMax, METH_VARARGS},
    {"GetMax", TensorAttributes_GetMax, METH_VARARGS},
    {"SetColorByEigenValues", TensorAttributes_SetColorByEigenValues, METH_VARARGS},
    {"GetColorByEigenValues", TensorAttributes_GetColorByEigenValues, METH_VARARGS},
    {"SetColorTableName", TensorAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", TensorAttributes_GetColorTableName, METH_VARARGS},
    {"SetInvertColorTable", TensorAttributes_SetInvertColorTable, METH_VARARGS},
    {"GetInvertColorTable", TensorAttributes_GetInvertColorTable, METH_VARARGS},
    {"SetTensorColor", TensorAttributes_SetTensorColor, METH_VARARGS},
    {"GetTensorColor", TensorAttributes_GetTensorColor, METH_VARARGS},
    {"SetUseLegend", TensorAttributes_SetUseLegend, METH_VARARGS},
    {"GetUseLegend", TensorAttributes_GetUseLegend, METH_VARARGS},
    {"SetScale", TensorAttributes_SetScale, METH_VARARGS},
    {"GetScale", TensorAttributes_GetScale, METH_VARARGS},
    {"SetScaleByMagnitude", TensorAttributes_SetScaleByMagnitude, METH_VARARGS},
    {"GetScaleByMagnitude", TensorAttributes_GetScaleByMagnitude, METH_VARARGS},
    {"SetAutoScale", TensorAttributes_SetAutoScale, METH_VARARGS},
    {"GetAutoScale", TensorAttributes_GetAutoScale, METH_VARARGS},
    {"SetAnimationStep", TensorAttributes_SetAnimationStep, METH_VARARGS},
    {"GetAnimationStep", TensorAttributes_GetAnimationStep, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TensorAttributes_dealloc(PyObject *v)
{
   TensorAttributesObject *obj = (TensorAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
TensorAttributes_compare(PyObject *v, PyObject *w)
{
    TensorAttributes *a = ((TensorAttributesObject *)v)->data;
    TensorAttributes *b = ((TensorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyTensorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "glyphLocation") == 0)
        return TensorAttributes_GetGlyphLocation(self, NULL);
    if(strcmp(name, "AdaptsToMeshResolution") == 0)
        return PyInt_FromLong(long(TensorAttributes::AdaptsToMeshResolution));
    if(strcmp(name, "UniformInSpace") == 0)
        return PyInt_FromLong(long(TensorAttributes::UniformInSpace));

    if(strcmp(name, "useStride") == 0)
        return TensorAttributes_GetUseStride(self, NULL);
    if(strcmp(name, "nTensors") == 0)
        return TensorAttributes_GetNTensors(self, NULL);
    if(strcmp(name, "stride") == 0)
        return TensorAttributes_GetStride(self, NULL);
    if(strcmp(name, "origOnly") == 0)
        return TensorAttributes_GetOrigOnly(self, NULL);
    if(strcmp(name, "limitsMode") == 0)
        return TensorAttributes_GetLimitsMode(self, NULL);
    if(strcmp(name, "OriginalData") == 0)
        return PyInt_FromLong(long(TensorAttributes::OriginalData));
    if(strcmp(name, "CurrentPlot") == 0)
        return PyInt_FromLong(long(TensorAttributes::CurrentPlot));

    if(strcmp(name, "minFlag") == 0)
        return TensorAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "min") == 0)
        return TensorAttributes_GetMin(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return TensorAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "max") == 0)
        return TensorAttributes_GetMax(self, NULL);
    if(strcmp(name, "colorByEigenValues") == 0)
        return TensorAttributes_GetColorByEigenValues(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return TensorAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "invertColorTable") == 0)
        return TensorAttributes_GetInvertColorTable(self, NULL);
    if(strcmp(name, "tensorColor") == 0)
        return TensorAttributes_GetTensorColor(self, NULL);
    if(strcmp(name, "useLegend") == 0)
        return TensorAttributes_GetUseLegend(self, NULL);
    if(strcmp(name, "scale") == 0)
        return TensorAttributes_GetScale(self, NULL);
    if(strcmp(name, "scaleByMagnitude") == 0)
        return TensorAttributes_GetScaleByMagnitude(self, NULL);
    if(strcmp(name, "autoScale") == 0)
        return TensorAttributes_GetAutoScale(self, NULL);
    if(strcmp(name, "animationStep") == 0)
        return TensorAttributes_GetAnimationStep(self, NULL);

    return Py_FindMethod(PyTensorAttributes_methods, self, name);
}

int
PyTensorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "glyphLocation") == 0)
        obj = TensorAttributes_SetGlyphLocation(self, tuple);
    else if(strcmp(name, "useStride") == 0)
        obj = TensorAttributes_SetUseStride(self, tuple);
    else if(strcmp(name, "nTensors") == 0)
        obj = TensorAttributes_SetNTensors(self, tuple);
    else if(strcmp(name, "stride") == 0)
        obj = TensorAttributes_SetStride(self, tuple);
    else if(strcmp(name, "origOnly") == 0)
        obj = TensorAttributes_SetOrigOnly(self, tuple);
    else if(strcmp(name, "limitsMode") == 0)
        obj = TensorAttributes_SetLimitsMode(self, tuple);
    else if(strcmp(name, "minFlag") == 0)
        obj = TensorAttributes_SetMinFlag(self, tuple);
    else if(strcmp(name, "min") == 0)
        obj = TensorAttributes_SetMin(self, tuple);
    else if(strcmp(name, "maxFlag") == 0)
        obj = TensorAttributes_SetMaxFlag(self, tuple);
    else if(strcmp(name, "max") == 0)
        obj = TensorAttributes_SetMax(self, tuple);
    else if(strcmp(name, "colorByEigenValues") == 0)
        obj = TensorAttributes_SetColorByEigenValues(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = TensorAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "invertColorTable") == 0)
        obj = TensorAttributes_SetInvertColorTable(self, tuple);
    else if(strcmp(name, "tensorColor") == 0)
        obj = TensorAttributes_SetTensorColor(self, tuple);
    else if(strcmp(name, "useLegend") == 0)
        obj = TensorAttributes_SetUseLegend(self, tuple);
    else if(strcmp(name, "scale") == 0)
        obj = TensorAttributes_SetScale(self, tuple);
    else if(strcmp(name, "scaleByMagnitude") == 0)
        obj = TensorAttributes_SetScaleByMagnitude(self, tuple);
    else if(strcmp(name, "autoScale") == 0)
        obj = TensorAttributes_SetAutoScale(self, tuple);
    else if(strcmp(name, "animationStep") == 0)
        obj = TensorAttributes_SetAnimationStep(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
TensorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)v;
    fprintf(fp, "%s", PyTensorAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
TensorAttributes_str(PyObject *v)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)v;
    return PyString_FromString(PyTensorAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *TensorAttributes_Purpose = "Attributes for the tensor plot";
#else
static char *TensorAttributes_Purpose = "Attributes for the tensor plot";
#endif

//
// The type description structure
//
static PyTypeObject TensorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TensorAttributes",                    // tp_name
    sizeof(TensorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TensorAttributes_dealloc,  // tp_dealloc
    (printfunc)TensorAttributes_print,     // tp_print
    (getattrfunc)PyTensorAttributes_getattr, // tp_getattr
    (setattrfunc)PyTensorAttributes_setattr, // tp_setattr
    (cmpfunc)TensorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)TensorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TensorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TensorAttributes *defaultAtts = 0;
static TensorAttributes *currentAtts = 0;

static PyObject *
NewTensorAttributes(int useCurrent)
{
    TensorAttributesObject *newObject;
    newObject = PyObject_NEW(TensorAttributesObject, &TensorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new TensorAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new TensorAttributes(*defaultAtts);
    else
        newObject->data = new TensorAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapTensorAttributes(const TensorAttributes *attr)
{
    TensorAttributesObject *newObject;
    newObject = PyObject_NEW(TensorAttributesObject, &TensorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TensorAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TensorAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewTensorAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TensorAttributesMethods[] = {
    {"TensorAttributes", TensorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TensorAttributesObserver = 0;

std::string
PyTensorAttributes_GetLogString()
{
    std::string s("TensorAtts = TensorAttributes()\n");
    if(currentAtts != 0)
        s += PyTensorAttributes_ToString(currentAtts, "TensorAtts.");
    return s;
}

static void
PyTensorAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("TensorAtts = TensorAttributes()\n");
        s += PyTensorAttributes_ToString(currentAtts, "TensorAtts.");
        cb(s);
    }
}

void
PyTensorAttributes_StartUp(TensorAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyTensorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TensorAttributesObserver == 0)
    {
        TensorAttributesObserver = new ObserverToCallback(subj,
            PyTensorAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyTensorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TensorAttributesObserver;
    TensorAttributesObserver = 0;
}

PyMethodDef *
PyTensorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TensorAttributesMethods;
}

bool
PyTensorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TensorAttributesType);
}

TensorAttributes *
PyTensorAttributes_FromPyObject(PyObject *obj)
{
    TensorAttributesObject *obj2 = (TensorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTensorAttributes_New()
{
    return NewTensorAttributes(0);
}

PyObject *
PyTensorAttributes_Wrap(const TensorAttributes *attr)
{
    return WrapTensorAttributes(attr);
}

void
PyTensorAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    TensorAttributesObject *obj2 = (TensorAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyTensorAttributes_SetDefaults(const TensorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TensorAttributes(*atts);
}

