// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SurfacePluginInfo.C
// ****************************************************************************

#include <SurfacePluginInfo.h>
#include <SurfaceAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Surface,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Surface,General)

// ****************************************************************************
//  Method: SurfaceGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfaceGeneralPluginInfo::GetName() const
{
    return "Surface";
}

// ****************************************************************************
//  Method: SurfaceGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfaceGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: SurfaceGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfaceGeneralPluginInfo::GetID() const
{
    return "Surface_1.0";
}
// ****************************************************************************
//  Method: SurfaceGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
SurfaceGeneralPluginInfo::EnabledByDefault() const
{
    return false;
}
