// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  SubsetScriptingPluginInfo.C
// ************************************************************************* //
#include <PySubsetAttributes.h>
#include <SubsetPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Subset,Scripting)

// ****************************************************************************
// Method: SubsetScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SubsetScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PySubsetAttributes_StartUp((SubsetAttributes *)subj, data);
}

// ****************************************************************************
// Method: SubsetScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
SubsetScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySubsetAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SubsetScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Subset plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SubsetScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySubsetAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SubsetScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
SubsetScriptingPluginInfo::GetLogString()
{
    std::string s(PySubsetAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: SubsetScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SubsetScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySubsetAttributes_SetDefaults((const SubsetAttributes *)atts);
}
