// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SubsetPluginInfo.C
// ****************************************************************************

#include <SubsetPluginInfo.h>
#include <SubsetAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Subset,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Subset,General)

// ****************************************************************************
//  Method: SubsetGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SubsetGeneralPluginInfo::GetName() const
{
    return "Subset";
}

// ****************************************************************************
//  Method: SubsetGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SubsetGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: SubsetGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SubsetGeneralPluginInfo::GetID() const
{
    return "Subset_1.0";
}
// ****************************************************************************
//  Method: SubsetGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
SubsetGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
