// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  SpreadsheetScriptingPluginInfo.C
// ************************************************************************* //
#include <PySpreadsheetAttributes.h>
#include <SpreadsheetPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Spreadsheet,Scripting)

// ****************************************************************************
// Method: SpreadsheetScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SpreadsheetScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PySpreadsheetAttributes_StartUp((SpreadsheetAttributes *)subj, data);
}

// ****************************************************************************
// Method: SpreadsheetScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
SpreadsheetScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySpreadsheetAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SpreadsheetScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Spreadsheet plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SpreadsheetScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySpreadsheetAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SpreadsheetScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
SpreadsheetScriptingPluginInfo::GetLogString()
{
    std::string s(PySpreadsheetAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: SpreadsheetScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SpreadsheetScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySpreadsheetAttributes_SetDefaults((const SpreadsheetAttributes *)atts);
}
