// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ScatterPluginInfo.C
// ****************************************************************************

#include <ScatterPluginInfo.h>
#include <ScatterAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Scatter,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Scatter,General)

// ****************************************************************************
//  Method: ScatterGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ScatterGeneralPluginInfo::GetName() const
{
    return "Scatter";
}

// ****************************************************************************
//  Method: ScatterGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ScatterGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ScatterGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ScatterGeneralPluginInfo::GetID() const
{
    return "Scatter_1.0";
}
// ****************************************************************************
//  Method: ScatterGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ScatterGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
