// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PseudocolorPluginInfo.C
// ****************************************************************************

#include <PseudocolorPluginInfo.h>
#include <PseudocolorAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Pseudocolor,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Pseudocolor,General)

// ****************************************************************************
//  Method: PseudocolorGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PseudocolorGeneralPluginInfo::GetName() const
{
    return "Pseudocolor";
}

// ****************************************************************************
//  Method: PseudocolorGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PseudocolorGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: PseudocolorGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PseudocolorGeneralPluginInfo::GetID() const
{
    return "Pseudocolor_1.0";
}
// ****************************************************************************
//  Method: PseudocolorGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
PseudocolorGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
