// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ParallelCoordinatesScriptingPluginInfo.C
// ************************************************************************* //
#include <PyParallelCoordinatesAttributes.h>
#include <ParallelCoordinatesPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(ParallelCoordinates,Scripting)

// ****************************************************************************
// Method: ParallelCoordinatesScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ParallelCoordinatesScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyParallelCoordinatesAttributes_StartUp((ParallelCoordinatesAttributes *)subj, data);
}

// ****************************************************************************
// Method: ParallelCoordinatesScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ParallelCoordinatesScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyParallelCoordinatesAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ParallelCoordinatesScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is ParallelCoordinates plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ParallelCoordinatesScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyParallelCoordinatesAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ParallelCoordinatesScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ParallelCoordinatesScriptingPluginInfo::GetLogString()
{
    std::string s(PyParallelCoordinatesAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ParallelCoordinatesScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ParallelCoordinatesScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyParallelCoordinatesAttributes_SetDefaults((const ParallelCoordinatesAttributes *)atts);
}
