// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef PARALLELCOORDINATESATTRIBUTES_H
#define PARALLELCOORDINATESATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

#include <ColorAttribute.h>
#include <AxisRestrictionAttributes.h>

// ****************************************************************************
// Class: ParallelCoordinatesAttributes
//
// Purpose:
//    This class contains the plot attributes for the ParallelCoordinates plot.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class ParallelCoordinatesAttributes : public AttributeSubject
{
public:
    enum FocusRendering
    {
        IndividualLines,
        BinsOfConstantColor,
        BinsColoredByPopulation
    };

    // These constructors are for objects of this class
    ParallelCoordinatesAttributes();
    ParallelCoordinatesAttributes(const ParallelCoordinatesAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ParallelCoordinatesAttributes(private_tmfs_t tmfs);
    ParallelCoordinatesAttributes(const ParallelCoordinatesAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ParallelCoordinatesAttributes();

    virtual ParallelCoordinatesAttributes& operator = (const ParallelCoordinatesAttributes &obj);
    virtual bool operator == (const ParallelCoordinatesAttributes &obj) const;
    virtual bool operator != (const ParallelCoordinatesAttributes &obj) const;
private:
    void Init();
    void Copy(const ParallelCoordinatesAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectScalarAxisNames();
    void SelectVisualAxisNames();
    void SelectExtentMinima();
    void SelectExtentMaxima();
    void SelectLinesColor();
    void SelectContextColor();

    // Property setting methods
    void SetScalarAxisNames(const stringVector &scalarAxisNames_);
    void SetVisualAxisNames(const stringVector &visualAxisNames_);
    void SetExtentMinima(const doubleVector &extentMinima_);
    void SetExtentMaxima(const doubleVector &extentMaxima_);
    void SetDrawLines(bool drawLines_);
    void SetLinesColor(const ColorAttribute &linesColor_);
    void SetDrawContext(bool drawContext_);
    void SetContextGamma(float contextGamma_);
    void SetContextNumPartitions(int contextNumPartitions_);
    void SetContextColor(const ColorAttribute &contextColor_);
    void SetDrawLinesOnlyIfExtentsOn(bool drawLinesOnlyIfExtentsOn_);
    void SetUnifyAxisExtents(bool unifyAxisExtents_);
    void SetLinesNumPartitions(int linesNumPartitions_);
    void SetFocusGamma(float focusGamma_);
    void SetDrawFocusAs(FocusRendering drawFocusAs_);

    // Property getting methods
    const stringVector   &GetScalarAxisNames() const;
          stringVector   &GetScalarAxisNames();
    const stringVector   &GetVisualAxisNames() const;
          stringVector   &GetVisualAxisNames();
    const doubleVector   &GetExtentMinima() const;
          doubleVector   &GetExtentMinima();
    const doubleVector   &GetExtentMaxima() const;
          doubleVector   &GetExtentMaxima();
    bool                 GetDrawLines() const;
    const ColorAttribute &GetLinesColor() const;
          ColorAttribute &GetLinesColor();
    bool                 GetDrawContext() const;
    float                GetContextGamma() const;
    int                  GetContextNumPartitions() const;
    const ColorAttribute &GetContextColor() const;
          ColorAttribute &GetContextColor();
    bool                 GetDrawLinesOnlyIfExtentsOn() const;
    bool                 GetUnifyAxisExtents() const;
    int                  GetLinesNumPartitions() const;
    float                GetFocusGamma() const;
    FocusRendering       GetDrawFocusAs() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string FocusRendering_ToString(FocusRendering);
    static bool FocusRendering_FromString(const std::string &, FocusRendering &);
protected:
    static std::string FocusRendering_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void InsertAxis(const std::string &axisName_);
    void DeleteAxis(const std::string &axisName_, int minAxisCount);
    bool AttributesAreConsistent() const;
    bool ChangesRequireRecalculation(const ParallelCoordinatesAttributes &obj);
    void ResetAxes();

    // IDs that can be used to identify fields in case statements
    enum {
        ID_scalarAxisNames = 0,
        ID_visualAxisNames,
        ID_extentMinima,
        ID_extentMaxima,
        ID_drawLines,
        ID_linesColor,
        ID_drawContext,
        ID_contextGamma,
        ID_contextNumPartitions,
        ID_contextColor,
        ID_drawLinesOnlyIfExtentsOn,
        ID_unifyAxisExtents,
        ID_linesNumPartitions,
        ID_focusGamma,
        ID_drawFocusAs,
        ID__LAST
    };

private:
    stringVector   scalarAxisNames;
    stringVector   visualAxisNames;
    doubleVector   extentMinima;
    doubleVector   extentMaxima;
    bool           drawLines;
    ColorAttribute linesColor;
    bool           drawContext;
    float          contextGamma;
    int            contextNumPartitions;
    ColorAttribute contextColor;
    bool           drawLinesOnlyIfExtentsOn;
    bool           unifyAxisExtents;
    int            linesNumPartitions;
    float          focusGamma;
    int            drawFocusAs;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define PARALLELCOORDINATESATTRIBUTES_TMFS "s*s*d*d*babfiabbifi"

#endif
