// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MultiCurveGUIPluginInfo.C
// ****************************************************************************

#include <MultiCurvePluginInfo.h>
#include <MultiCurveAttributes.h>
#include <QApplication>
#include <QvisMultiCurvePlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(MultiCurve,GUI)

// ****************************************************************************
//  Method: MultiCurveGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
MultiCurveGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "MultiCurve"));
}


// ****************************************************************************
//  Method: MultiCurveGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
MultiCurveGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisMultiCurvePlotWindow(type, (MultiCurveAttributes *)attr,
        caption, shortName, notepad);
}

