// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MoleculeViewerEnginePluginInfo.C
// ****************************************************************************

#include <MoleculePluginInfo.h>
#include <avtMoleculePlot.h>
#include <MoleculeAttributes.h>

//
// Storage for static data elements.
//
MoleculeAttributes *MoleculeViewerEnginePluginInfo::clientAtts = NULL;
MoleculeAttributes *MoleculeViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  MoleculeViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
MoleculeViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (MoleculeViewerEnginePluginInfo::clientAtts == NULL)
    {
        MoleculeViewerEnginePluginInfo::clientAtts  = new MoleculeAttributes;
        MoleculeViewerEnginePluginInfo::defaultAtts = new MoleculeAttributes;
    }
}

// ****************************************************************************
//  Method: MoleculeViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MoleculeViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: MoleculeViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MoleculeViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: MoleculeViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MoleculeViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(MoleculeAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: MoleculeViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MoleculeViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(MoleculeAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: MoleculeViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
MoleculeViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtMoleculePlot;
}

// ****************************************************************************
//  Method: MoleculeViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    plot      The viewer plot whose attributes are getting initialized.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MoleculeViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    *(MoleculeAttributes*)atts = *defaultAtts;
}
// ****************************************************************************
//  Method: MoleculeViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MoleculeViewerEnginePluginInfo::GetMenuName() const
{
    return "Molecule";
}

