// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  MeshScriptingPluginInfo.C
// ************************************************************************* //
#include <PyMeshAttributes.h>
#include <MeshPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Mesh,Scripting)

// ****************************************************************************
// Method: MeshScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MeshScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyMeshAttributes_StartUp((MeshAttributes *)subj, data);
}

// ****************************************************************************
// Method: MeshScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
MeshScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyMeshAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: MeshScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Mesh plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MeshScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyMeshAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: MeshScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
MeshScriptingPluginInfo::GetLogString()
{
    std::string s(PyMeshAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: MeshScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MeshScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyMeshAttributes_SetDefaults((const MeshAttributes *)atts);
}
