// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MeshCommonPluginInfo.C
// ****************************************************************************

#include <MeshPluginInfo.h>
#include <MeshAttributes.h>

// ****************************************************************************
//  Method: MeshCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MeshCommonPluginInfo::AllocAttributes()
{
    return new MeshAttributes;
}

// ****************************************************************************
//  Method: MeshCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Mesh attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MeshCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((MeshAttributes *) to) = *((MeshAttributes *) from);
}

// ****************************************************************************
// Method: MeshCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
MeshCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MESH;
}

