// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorAttribute;

// ****************************************************************************
// Class: MeshAttributes
//
// Purpose:
//    Attributes for the mesh plot
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class MeshAttributes extends AttributeSubject implements Plugin
{
    private static int MeshAttributes_numAdditionalAtts = 16;

    // Enum values
    public final static int SMOOTHINGLEVEL_NONE = 0;
    public final static int SMOOTHINGLEVEL_FAST = 1;
    public final static int SMOOTHINGLEVEL_HIGH = 2;

    public final static int MESHCOLOR_FOREGROUND = 0;
    public final static int MESHCOLOR_MESHCUSTOM = 1;
    public final static int MESHCOLOR_MESHRANDOM = 2;

    public final static int OPAQUECOLOR_BACKGROUND = 0;
    public final static int OPAQUECOLOR_OPAQUECUSTOM = 1;
    public final static int OPAQUECOLOR_OPAQUERANDOM = 2;

    public final static int OPAQUEMODE_AUTO = 0;
    public final static int OPAQUEMODE_ON = 1;
    public final static int OPAQUEMODE_OFF = 2;


    public MeshAttributes()
    {
        super(MeshAttributes_numAdditionalAtts);

        legendFlag = true;
        lineWidth = 0;
        meshColor = new ColorAttribute(0, 0, 0);
        meshColorSource = MESHCOLOR_FOREGROUND;
        opaqueColorSource = OPAQUECOLOR_BACKGROUND;
        opaqueMode = OPAQUEMODE_AUTO;
        pointSize = 0.05;
        opaqueColor = new ColorAttribute(255, 255, 255);
        smoothingLevel = SMOOTHINGLEVEL_NONE;
        pointSizeVarEnabled = false;
        pointSizeVar = new String("default");
        pointType = 6;
        opaqueMeshIsAppropriate = true;
        showInternal = false;
        pointSizePixels = 2;
        opacity = 1;
    }

    public MeshAttributes(int nMoreFields)
    {
        super(MeshAttributes_numAdditionalAtts + nMoreFields);

        legendFlag = true;
        lineWidth = 0;
        meshColor = new ColorAttribute(0, 0, 0);
        meshColorSource = MESHCOLOR_FOREGROUND;
        opaqueColorSource = OPAQUECOLOR_BACKGROUND;
        opaqueMode = OPAQUEMODE_AUTO;
        pointSize = 0.05;
        opaqueColor = new ColorAttribute(255, 255, 255);
        smoothingLevel = SMOOTHINGLEVEL_NONE;
        pointSizeVarEnabled = false;
        pointSizeVar = new String("default");
        pointType = 6;
        opaqueMeshIsAppropriate = true;
        showInternal = false;
        pointSizePixels = 2;
        opacity = 1;
    }

    public MeshAttributes(MeshAttributes obj)
    {
        super(obj);

        legendFlag = obj.legendFlag;
        lineWidth = obj.lineWidth;
        meshColor = new ColorAttribute(obj.meshColor);
        meshColorSource = obj.meshColorSource;
        opaqueColorSource = obj.opaqueColorSource;
        opaqueMode = obj.opaqueMode;
        pointSize = obj.pointSize;
        opaqueColor = new ColorAttribute(obj.opaqueColor);
        smoothingLevel = obj.smoothingLevel;
        pointSizeVarEnabled = obj.pointSizeVarEnabled;
        pointSizeVar = new String(obj.pointSizeVar);
        pointType = obj.pointType;
        opaqueMeshIsAppropriate = obj.opaqueMeshIsAppropriate;
        showInternal = obj.showInternal;
        pointSizePixels = obj.pointSizePixels;
        opacity = obj.opacity;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return MeshAttributes_numAdditionalAtts;
    }

    public boolean equals(MeshAttributes obj)
    {
        // Create the return value
        return ((legendFlag == obj.legendFlag) &&
                (lineWidth == obj.lineWidth) &&
                (meshColor == obj.meshColor) &&
                (meshColorSource == obj.meshColorSource) &&
                (opaqueColorSource == obj.opaqueColorSource) &&
                (opaqueMode == obj.opaqueMode) &&
                (pointSize == obj.pointSize) &&
                (opaqueColor == obj.opaqueColor) &&
                (smoothingLevel == obj.smoothingLevel) &&
                (pointSizeVarEnabled == obj.pointSizeVarEnabled) &&
                (pointSizeVar.equals(obj.pointSizeVar)) &&
                (pointType == obj.pointType) &&
                (opaqueMeshIsAppropriate == obj.opaqueMeshIsAppropriate) &&
                (showInternal == obj.showInternal) &&
                (pointSizePixels == obj.pointSizePixels) &&
                (opacity == obj.opacity));
    }

    public String GetName() { return "Mesh"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetLegendFlag(boolean legendFlag_)
    {
        legendFlag = legendFlag_;
        Select(0);
    }

    public void SetLineWidth(int lineWidth_)
    {
        lineWidth = lineWidth_;
        Select(1);
    }

    public void SetMeshColor(ColorAttribute meshColor_)
    {
        meshColor = meshColor_;
        Select(2);
    }

    public void SetMeshColorSource(int meshColorSource_)
    {
        meshColorSource = meshColorSource_;
        Select(3);
    }

    public void SetOpaqueColorSource(int opaqueColorSource_)
    {
        opaqueColorSource = opaqueColorSource_;
        Select(4);
    }

    public void SetOpaqueMode(int opaqueMode_)
    {
        opaqueMode = opaqueMode_;
        Select(5);
    }

    public void SetPointSize(double pointSize_)
    {
        pointSize = pointSize_;
        Select(6);
    }

    public void SetOpaqueColor(ColorAttribute opaqueColor_)
    {
        opaqueColor = opaqueColor_;
        Select(7);
    }

    public void SetSmoothingLevel(int smoothingLevel_)
    {
        smoothingLevel = smoothingLevel_;
        Select(8);
    }

    public void SetPointSizeVarEnabled(boolean pointSizeVarEnabled_)
    {
        pointSizeVarEnabled = pointSizeVarEnabled_;
        Select(9);
    }

    public void SetPointSizeVar(String pointSizeVar_)
    {
        pointSizeVar = pointSizeVar_;
        Select(10);
    }

    public void SetPointType(int pointType_)
    {
        pointType = pointType_;
        Select(11);
    }

    public void SetOpaqueMeshIsAppropriate(boolean opaqueMeshIsAppropriate_)
    {
        opaqueMeshIsAppropriate = opaqueMeshIsAppropriate_;
        Select(12);
    }

    public void SetShowInternal(boolean showInternal_)
    {
        showInternal = showInternal_;
        Select(13);
    }

    public void SetPointSizePixels(int pointSizePixels_)
    {
        pointSizePixels = pointSizePixels_;
        Select(14);
    }

    public void SetOpacity(double opacity_)
    {
        opacity = opacity_;
        Select(15);
    }

    // Property getting methods
    public boolean        GetLegendFlag() { return legendFlag; }
    public int            GetLineWidth() { return lineWidth; }
    public ColorAttribute GetMeshColor() { return meshColor; }
    public int            GetMeshColorSource() { return meshColorSource; }
    public int            GetOpaqueColorSource() { return opaqueColorSource; }
    public int            GetOpaqueMode() { return opaqueMode; }
    public double         GetPointSize() { return pointSize; }
    public ColorAttribute GetOpaqueColor() { return opaqueColor; }
    public int            GetSmoothingLevel() { return smoothingLevel; }
    public boolean        GetPointSizeVarEnabled() { return pointSizeVarEnabled; }
    public String         GetPointSizeVar() { return pointSizeVar; }
    public int GetPointType() { return pointType; }
    public boolean        GetOpaqueMeshIsAppropriate() { return opaqueMeshIsAppropriate; }
    public boolean        GetShowInternal() { return showInternal; }
    public int            GetPointSizePixels() { return pointSizePixels; }
    public double         GetOpacity() { return opacity; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(legendFlag);
        if(WriteSelect(1, buf))
            buf.WriteInt(lineWidth);
        if(WriteSelect(2, buf))
            meshColor.Write(buf);
        if(WriteSelect(3, buf))
            buf.WriteInt(meshColorSource);
        if(WriteSelect(4, buf))
            buf.WriteInt(opaqueColorSource);
        if(WriteSelect(5, buf))
            buf.WriteInt(opaqueMode);
        if(WriteSelect(6, buf))
            buf.WriteDouble(pointSize);
        if(WriteSelect(7, buf))
            opaqueColor.Write(buf);
        if(WriteSelect(8, buf))
            buf.WriteInt(smoothingLevel);
        if(WriteSelect(9, buf))
            buf.WriteBool(pointSizeVarEnabled);
        if(WriteSelect(10, buf))
            buf.WriteString(pointSizeVar);
        if(WriteSelect(11, buf))
            buf.WriteInt(pointType);
        if(WriteSelect(12, buf))
            buf.WriteBool(opaqueMeshIsAppropriate);
        if(WriteSelect(13, buf))
            buf.WriteBool(showInternal);
        if(WriteSelect(14, buf))
            buf.WriteInt(pointSizePixels);
        if(WriteSelect(15, buf))
            buf.WriteDouble(opacity);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetLegendFlag(buf.ReadBool());
            break;
        case 1:
            SetLineWidth(buf.ReadInt());
            break;
        case 2:
            meshColor.Read(buf);
            Select(2);
            break;
        case 3:
            SetMeshColorSource(buf.ReadInt());
            break;
        case 4:
            SetOpaqueColorSource(buf.ReadInt());
            break;
        case 5:
            SetOpaqueMode(buf.ReadInt());
            break;
        case 6:
            SetPointSize(buf.ReadDouble());
            break;
        case 7:
            opaqueColor.Read(buf);
            Select(7);
            break;
        case 8:
            SetSmoothingLevel(buf.ReadInt());
            break;
        case 9:
            SetPointSizeVarEnabled(buf.ReadBool());
            break;
        case 10:
            SetPointSizeVar(buf.ReadString());
            break;
        case 11:
            SetPointType(buf.ReadInt());
            break;
        case 12:
            SetOpaqueMeshIsAppropriate(buf.ReadBool());
            break;
        case 13:
            SetShowInternal(buf.ReadBool());
            break;
        case 14:
            SetPointSizePixels(buf.ReadInt());
            break;
        case 15:
            SetOpacity(buf.ReadDouble());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + boolToString("legendFlag", legendFlag, indent) + "\n";
        str = str + intToString("lineWidth", lineWidth, indent) + "\n";
        str = str + indent + "meshColor = {" + meshColor.Red() + ", " + meshColor.Green() + ", " + meshColor.Blue() + ", " + meshColor.Alpha() + "}\n";
        str = str + indent + "meshColorSource = ";
        if(meshColorSource == MESHCOLOR_FOREGROUND)
            str = str + "MESHCOLOR_FOREGROUND";
        if(meshColorSource == MESHCOLOR_MESHCUSTOM)
            str = str + "MESHCOLOR_MESHCUSTOM";
        if(meshColorSource == MESHCOLOR_MESHRANDOM)
            str = str + "MESHCOLOR_MESHRANDOM";
        str = str + "\n";
        str = str + indent + "opaqueColorSource = ";
        if(opaqueColorSource == OPAQUECOLOR_BACKGROUND)
            str = str + "OPAQUECOLOR_BACKGROUND";
        if(opaqueColorSource == OPAQUECOLOR_OPAQUECUSTOM)
            str = str + "OPAQUECOLOR_OPAQUECUSTOM";
        if(opaqueColorSource == OPAQUECOLOR_OPAQUERANDOM)
            str = str + "OPAQUECOLOR_OPAQUERANDOM";
        str = str + "\n";
        str = str + indent + "opaqueMode = ";
        if(opaqueMode == OPAQUEMODE_AUTO)
            str = str + "OPAQUEMODE_AUTO";
        if(opaqueMode == OPAQUEMODE_ON)
            str = str + "OPAQUEMODE_ON";
        if(opaqueMode == OPAQUEMODE_OFF)
            str = str + "OPAQUEMODE_OFF";
        str = str + "\n";
        str = str + doubleToString("pointSize", pointSize, indent) + "\n";
        str = str + indent + "opaqueColor = {" + opaqueColor.Red() + ", " + opaqueColor.Green() + ", " + opaqueColor.Blue() + ", " + opaqueColor.Alpha() + "}\n";
        str = str + indent + "smoothingLevel = ";
        if(smoothingLevel == SMOOTHINGLEVEL_NONE)
            str = str + "SMOOTHINGLEVEL_NONE";
        if(smoothingLevel == SMOOTHINGLEVEL_FAST)
            str = str + "SMOOTHINGLEVEL_FAST";
        if(smoothingLevel == SMOOTHINGLEVEL_HIGH)
            str = str + "SMOOTHINGLEVEL_HIGH";
        str = str + "\n";
        str = str + boolToString("pointSizeVarEnabled", pointSizeVarEnabled, indent) + "\n";
        str = str + stringToString("pointSizeVar", pointSizeVar, indent) + "\n";
        str = str + intToString("pointType", pointType, indent) + "\n";
        str = str + boolToString("opaqueMeshIsAppropriate", opaqueMeshIsAppropriate, indent) + "\n";
        str = str + boolToString("showInternal", showInternal, indent) + "\n";
        str = str + intToString("pointSizePixels", pointSizePixels, indent) + "\n";
        str = str + doubleToString("opacity", opacity, indent) + "\n";
        return str;
    }


    // Attributes
    private boolean        legendFlag;
    private int            lineWidth;
    private ColorAttribute meshColor;
    private int            meshColorSource;
    private int            opaqueColorSource;
    private int            opaqueMode;
    private double         pointSize;
    private ColorAttribute opaqueColor;
    private int            smoothingLevel;
    private boolean        pointSizeVarEnabled;
    private String         pointSizeVar;
    private int pointType;
    private boolean        opaqueMeshIsAppropriate;
    private boolean        showInternal;
    private int            pointSizePixels;
    private double         opacity;
}

