// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LabelPluginInfo.C
// ****************************************************************************

#include <LabelPluginInfo.h>
#include <LabelAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Label,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Label,General)

// ****************************************************************************
//  Method: LabelGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LabelGeneralPluginInfo::GetName() const
{
    return "Label";
}

// ****************************************************************************
//  Method: LabelGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LabelGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: LabelGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LabelGeneralPluginInfo::GetID() const
{
    return "Label_1.0";
}
// ****************************************************************************
//  Method: LabelGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
LabelGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
