// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LabelGUIPluginInfo.C
// ****************************************************************************

#include <LabelPluginInfo.h>
#include <LabelAttributes.h>
#include <QApplication>
#include <QvisLabelPlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(Label,GUI)

// ****************************************************************************
//  Method: LabelGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
LabelGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Label"));
}


// ****************************************************************************
//  Method: LabelGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
LabelGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisLabelPlotWindow(type, (LabelAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: LabelGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Label.xpm>
const char **
LabelGUIPluginInfo::XPMIconData() const
{
    return Label_xpm;
}

