// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                           avtHistogramFilter.h                            //
// ************************************************************************* //

#ifndef AVT_Histogram_FILTER_H
#define AVT_Histogram_FILTER_H

#include <avtDataTreeIterator.h>

#include <HistogramAttributes.h>


// ****************************************************************************
//  Class: avtHistogramFilter
//
//  Purpose:
//      This operator is the implied operator associated with an Histogram plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 26 09:04:54 PDT 2003
//
//  Modifications:
//
//    Hank Childs, Sat Oct 18 12:14:32 PDT 2003
//    Added ModifyContract to disable ghost zone generation.
//
//    Hank Childs, Wed May 24 10:00:12 PDT 2006
//    Added support for array variables.
//
//    Cyrus Harrison, Fri Mar  9 09:11:34 PST 2007
//    Added support for point histograms and true "Frequency" histograms
//
//    Dave Pugmire, Thu Nov 01 12:39:07 EDT 2007
//    Support for log, sqrt scaling.        
//
//    Hank Childs, Tue Dec 11 20:25:22 PST 2007
//    Added support for weighting by a variable.
//
//    Eric Brugger, Mon Aug  2 13:00:36 PDT 2010
//    I changed the data type of workingRange from double to float to avoid
//    a problem where the raw data to be processed may be outside of the
//    working range.
//
//    Kevin Bensema, Mon Nov 11 12:42 2013
//    Modified ScaleBins to compute CDFs and normalization.
//
//    Eric Brugger, Tue Aug 19 10:28:00 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
//    Mark C. Miller, Thu Jan  8 14:27:03 PST 2015
//    Adjusted to use doubles everywhere.
// ****************************************************************************

class avtHistogramFilter : public avtDataTreeIterator
{
  public:
                              avtHistogramFilter();
    virtual                  ~avtHistogramFilter();

    virtual const char       *GetType(void)   { return "avtHistogramFilter"; };
    virtual const char       *GetDescription(void)
                                  { return "Performing Histogram"; };

    void                      SetAttributes(const HistogramAttributes &);
   
  protected:
    HistogramAttributes       atts;
    double                   *bins;
    double                    binStep, logBinStep, sqrtBinStep;
    double                    dataValueRange[2];
    double                    workingRange[2];
    double                    logWorkingRange[2], sqrtWorkingRange[2];
    int                       workingNumBins;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual void              UpdateDataObjectInfo(void);
    virtual void              PreExecute();
    virtual void              PostExecute();
    virtual avtContract_p     ModifyContract(avtContract_p);
    virtual bool              ThreadSafe(void);

    virtual void              FreqzExecute(vtkDataSet *);
    virtual void              WeightedExecute(vtkDataSet *);
    virtual void              VariableExecute(vtkDataSet *);
    virtual void              ArrayVarExecute(vtkDataSet *, int);

    virtual int               ComputeBinIndex( const double &value ) const;
    virtual void              ScaleBins();
    virtual void              SetWorkingMin( double dataMin );
    virtual double            GetWorkingMin() const;
    virtual void              SetWorkingMax( double dataMax );
    virtual double            GetWorkingMax() const;
    virtual void              SetWorkingNumBins( int n );
};


#endif


