// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: HistogramGUIPluginInfo.C
// ****************************************************************************

#include <HistogramPluginInfo.h>
#include <HistogramAttributes.h>
#include <QApplication>
#include <QvisHistogramPlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(Histogram,GUI)

// ****************************************************************************
//  Method: HistogramGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
HistogramGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Histogram"));
}


// ****************************************************************************
//  Method: HistogramGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
HistogramGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisHistogramPlotWindow(type, (HistogramAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: HistogramGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Histogram.xpm>
const char **
HistogramGUIPluginInfo::XPMIconData() const
{
    return Histogram_xpm;
}

