// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyFilledBoundaryAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <ColorAttribute.h>
#include <PyColorAttributeList.h>
#include <ColorAttribute.h>
#include <GlyphTypes.h>

// ****************************************************************************
// Module: PyFilledBoundaryAttributes
//
// Purpose:
//   This class contains the plot attributes for the filled boundary plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a FilledBoundaryAttributes.
//
struct FilledBoundaryAttributesObject
{
    PyObject_HEAD
    FilledBoundaryAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewFilledBoundaryAttributes(int);

std::string
PyFilledBoundaryAttributes_ToString(const FilledBoundaryAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    switch (atts->GetColorType())
    {
      case FilledBoundaryAttributes::ColorBySingleColor:
          snprintf(tmpStr, 1000, "%scolorType = %sColorBySingleColor  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case FilledBoundaryAttributes::ColorByMultipleColors:
          snprintf(tmpStr, 1000, "%scolorType = %sColorByMultipleColors  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case FilledBoundaryAttributes::ColorByColorTable:
          snprintf(tmpStr, 1000, "%scolorType = %sColorByColorTable  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    if(atts->GetInvertColorTable())
        snprintf(tmpStr, 1000, "%sinvertColorTable = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sinvertColorTable = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLegendFlag())
        snprintf(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    snprintf(tmpStr, 1000, "%ssingleColor = (%d, %d, %d, %d)\n", prefix, int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    { const ColorAttributeList &cL = atts->GetMultiColor();
        const char *comment = (prefix==0 || strcmp(prefix,"")==0) ? "# " : "";
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL[i].GetColor();
            snprintf(tmpStr, 1000, "%s%sSetMultiColor(%d, (%d, %d, %d, %d))\n",
                     comment, prefix, i, int(c[0]), int(c[1]), int(c[2]), int(c[3]));
            str += tmpStr;
        }
    }
    {   const stringVector &boundaryNames = atts->GetBoundaryNames();
        snprintf(tmpStr, 1000, "%sboundaryNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < boundaryNames.size(); ++i)
        {
            snprintf(tmpStr, 1000, "\"%s\"", boundaryNames[i].c_str());
            str += tmpStr;
            if(i < boundaryNames.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%sopacity = %g\n", prefix, atts->GetOpacity());
    str += tmpStr;
    if(atts->GetWireframe())
        snprintf(tmpStr, 1000, "%swireframe = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%swireframe = 0\n", prefix);
    str += tmpStr;
    if(atts->GetDrawInternal())
        snprintf(tmpStr, 1000, "%sdrawInternal = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sdrawInternal = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%ssmoothingLevel = %d\n", prefix, atts->GetSmoothingLevel());
    str += tmpStr;
    if(atts->GetCleanZonesOnly())
        snprintf(tmpStr, 1000, "%scleanZonesOnly = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%scleanZonesOnly = 0\n", prefix);
    str += tmpStr;
    const unsigned char *mixedColor = atts->GetMixedColor().GetColor();
    snprintf(tmpStr, 1000, "%smixedColor = (%d, %d, %d, %d)\n", prefix, int(mixedColor[0]), int(mixedColor[1]), int(mixedColor[2]), int(mixedColor[3]));
    str += tmpStr;
    snprintf(tmpStr, 1000, "%spointSize = %g\n", prefix, atts->GetPointSize());
    str += tmpStr;
    const char *pointType_names = "Box, Axis, Icosahedron, Octahedron, Tetrahedron, "
        "SphereGeometry, Point, Sphere";
    switch (atts->GetPointType())
    {
      case Box:
          snprintf(tmpStr, 1000, "%spointType = %sBox  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Axis:
          snprintf(tmpStr, 1000, "%spointType = %sAxis  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Icosahedron:
          snprintf(tmpStr, 1000, "%spointType = %sIcosahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Octahedron:
          snprintf(tmpStr, 1000, "%spointType = %sOctahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Tetrahedron:
          snprintf(tmpStr, 1000, "%spointType = %sTetrahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case SphereGeometry:
          snprintf(tmpStr, 1000, "%spointType = %sSphereGeometry  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Point:
          snprintf(tmpStr, 1000, "%spointType = %sPoint  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Sphere:
          snprintf(tmpStr, 1000, "%spointType = %sSphere  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetPointSizeVarEnabled())
        snprintf(tmpStr, 1000, "%spointSizeVarEnabled = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%spointSizeVarEnabled = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%spointSizeVar = \"%s\"\n", prefix, atts->GetPointSizeVar().c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%spointSizePixels = %d\n", prefix, atts->GetPointSizePixels());
    str += tmpStr;
    return str;
}

static PyObject *
FilledBoundaryAttributes_Notify(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetColorType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetColorType(FilledBoundaryAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetColorType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetInvertColorTable(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the invertColorTable in the object.
    obj->data->SetInvertColorTable(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetInvertColorTable(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInvertColorTable()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetMultiColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    PyObject *pyobj = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();
    int index = 0;
    int c[4] = {0,0,0,255};
    bool setTheColor = true;

    if(!PyArg_ParseTuple(args, "iiiii", &index, &c[0], &c[1], &c[2], &c[3]))
    {
        if(!PyArg_ParseTuple(args, "iiii", &index, &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "idddd", &index, &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "iddd", &index, &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                if(!PyArg_ParseTuple(args, "iO", &index, &pyobj))
                {
                    if(PyArg_ParseTuple(args, "O", &pyobj))
                    {
                        setTheColor = false;
                        if(PyTuple_Check(pyobj))
                        {
                            // Make sure that the tuple is the right size.
                            if(PyTuple_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyTuple_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   (PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4))
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);
                            delete [] C;
                        }
                        else if(PyList_Check(pyobj))
                        {
                            // Make sure that the list is the right size.
                            if(PyList_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyList_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyList_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   (PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4))
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);

                            delete [] C;
                        }
                        else
                            return NULL;
                    }
                }
                else
                {
                    if(!PyTuple_Check(pyobj))
                        return NULL;

                    // Make sure that the tuple is the right size.
                    if(PyTuple_Size(pyobj) < 3 || PyTuple_Size(pyobj) > 4)
                        return NULL;

                    // Make sure that all elements in the tuple are ints.
                    for(int i = 0; i < PyTuple_Size(pyobj); ++i)
                    {
                        PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                        if(PyInt_Check(item))
                            c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(pyobj, i)));
                        else if(PyFloat_Check(item))
                            c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(pyobj, i)));
                        else
                            return NULL;
                    }
                }
            }
        }
        PyErr_Clear();
    }

    if(index < 0 || index >= cL.GetNumColors())
        return NULL;

    // Set the color in the object.
    if(setTheColor)
        cL[index] = ColorAttribute(c[0], c[1], c[2], c[3]);
    cL.SelectColors();
    obj->data->SelectMultiColor();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetMultiColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();

    int index = 0;
    if(PyArg_ParseTuple(args, "i", &index))
    {
        if(index < 0 || index >= cL.GetNumColors())
            return NULL;

        // Allocate a tuple the with enough entries to hold the singleColor.
        retval = PyTuple_New(4);
        const unsigned char *c = cL.GetColors(index).GetColor();
        PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(c[0])));
        PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(c[1])));
        PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(c[2])));
        PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(c[3])));
    }
    else
    {
        PyErr_Clear();

        // Return the whole thing.
        retval = PyList_New(cL.GetNumColors());
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL.GetColors(i).GetColor();

            PyObject *t = PyTuple_New(4);
            PyTuple_SET_ITEM(t, 0, PyInt_FromLong(long(c[0])));
            PyTuple_SET_ITEM(t, 1, PyInt_FromLong(long(c[1])));
            PyTuple_SET_ITEM(t, 2, PyInt_FromLong(long(c[2])));
            PyTuple_SET_ITEM(t, 3, PyInt_FromLong(long(c[3])));

            PyList_SET_ITEM(retval, i, t);
        }
    }
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetBoundaryNames(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    stringVector  &vec = obj->data->GetBoundaryNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the boundaryNames in the object as modified.
    obj->data->SelectBoundaryNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetBoundaryNames(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the boundaryNames.
    const stringVector &boundaryNames = obj->data->GetBoundaryNames();
    PyObject *retval = PyTuple_New(boundaryNames.size());
    for(size_t i = 0; i < boundaryNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(boundaryNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetWireframe(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wireframe in the object.
    obj->data->SetWireframe(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetWireframe(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWireframe()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetDrawInternal(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawInternal in the object.
    obj->data->SetDrawInternal(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetDrawInternal(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDrawInternal()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetSmoothingLevel(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothingLevel in the object.
    obj->data->SetSmoothingLevel((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetSmoothingLevel(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothingLevel()));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetCleanZonesOnly(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cleanZonesOnly in the object.
    obj->data->SetCleanZonesOnly(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetCleanZonesOnly(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCleanZonesOnly()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetMixedColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the mixedColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetMixedColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetMixedColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the mixedColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *mixedColor = obj->data->GetMixedColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(mixedColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(mixedColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(mixedColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(mixedColor[3])));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetPointType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    if(ival >= 0 && ival < 8)
    {
        obj->data->SetPointType(GlyphType(ival));
    }
    else
    {
        fprintf(stderr, "An invalid pointType value was given. "
                        "Valid values are in the range of [0,7]. "
                        "You can also use the following names: "
                        "Box, Axis, Icosahedron, Octahedron, Tetrahedron, "
                        "SphereGeometry, Point, Sphere.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetPointType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointType()));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizeVarEnabled in the object.
    obj->data->SetPointSizeVarEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPointSizeVarEnabled()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetPointSizeVar(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the pointSizeVar in the object.
    obj->data->SetPointSizeVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetPointSizeVar(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPointSizeVar().c_str());
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetPointSizePixels(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizePixels in the object.
    obj->data->SetPointSizePixels((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetPointSizePixels(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointSizePixels()));
    return retval;
}



PyMethodDef PyFilledBoundaryAttributes_methods[FILLEDBOUNDARYATTRIBUTES_NMETH] = {
    {"Notify", FilledBoundaryAttributes_Notify, METH_VARARGS},
    {"SetColorType", FilledBoundaryAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", FilledBoundaryAttributes_GetColorType, METH_VARARGS},
    {"SetColorTableName", FilledBoundaryAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", FilledBoundaryAttributes_GetColorTableName, METH_VARARGS},
    {"SetInvertColorTable", FilledBoundaryAttributes_SetInvertColorTable, METH_VARARGS},
    {"GetInvertColorTable", FilledBoundaryAttributes_GetInvertColorTable, METH_VARARGS},
    {"SetLegendFlag", FilledBoundaryAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", FilledBoundaryAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLineWidth", FilledBoundaryAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", FilledBoundaryAttributes_GetLineWidth, METH_VARARGS},
    {"SetSingleColor", FilledBoundaryAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", FilledBoundaryAttributes_GetSingleColor, METH_VARARGS},
    {"SetMultiColor", FilledBoundaryAttributes_SetMultiColor, METH_VARARGS},
    {"GetMultiColor", FilledBoundaryAttributes_GetMultiColor, METH_VARARGS},
    {"SetBoundaryNames", FilledBoundaryAttributes_SetBoundaryNames, METH_VARARGS},
    {"GetBoundaryNames", FilledBoundaryAttributes_GetBoundaryNames, METH_VARARGS},
    {"SetOpacity", FilledBoundaryAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", FilledBoundaryAttributes_GetOpacity, METH_VARARGS},
    {"SetWireframe", FilledBoundaryAttributes_SetWireframe, METH_VARARGS},
    {"GetWireframe", FilledBoundaryAttributes_GetWireframe, METH_VARARGS},
    {"SetDrawInternal", FilledBoundaryAttributes_SetDrawInternal, METH_VARARGS},
    {"GetDrawInternal", FilledBoundaryAttributes_GetDrawInternal, METH_VARARGS},
    {"SetSmoothingLevel", FilledBoundaryAttributes_SetSmoothingLevel, METH_VARARGS},
    {"GetSmoothingLevel", FilledBoundaryAttributes_GetSmoothingLevel, METH_VARARGS},
    {"SetCleanZonesOnly", FilledBoundaryAttributes_SetCleanZonesOnly, METH_VARARGS},
    {"GetCleanZonesOnly", FilledBoundaryAttributes_GetCleanZonesOnly, METH_VARARGS},
    {"SetMixedColor", FilledBoundaryAttributes_SetMixedColor, METH_VARARGS},
    {"GetMixedColor", FilledBoundaryAttributes_GetMixedColor, METH_VARARGS},
    {"SetPointSize", FilledBoundaryAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", FilledBoundaryAttributes_GetPointSize, METH_VARARGS},
    {"SetPointType", FilledBoundaryAttributes_SetPointType, METH_VARARGS},
    {"GetPointType", FilledBoundaryAttributes_GetPointType, METH_VARARGS},
    {"SetPointSizeVarEnabled", FilledBoundaryAttributes_SetPointSizeVarEnabled, METH_VARARGS},
    {"GetPointSizeVarEnabled", FilledBoundaryAttributes_GetPointSizeVarEnabled, METH_VARARGS},
    {"SetPointSizeVar", FilledBoundaryAttributes_SetPointSizeVar, METH_VARARGS},
    {"GetPointSizeVar", FilledBoundaryAttributes_GetPointSizeVar, METH_VARARGS},
    {"SetPointSizePixels", FilledBoundaryAttributes_SetPointSizePixels, METH_VARARGS},
    {"GetPointSizePixels", FilledBoundaryAttributes_GetPointSizePixels, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
FilledBoundaryAttributes_dealloc(PyObject *v)
{
   FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
FilledBoundaryAttributes_compare(PyObject *v, PyObject *w)
{
    FilledBoundaryAttributes *a = ((FilledBoundaryAttributesObject *)v)->data;
    FilledBoundaryAttributes *b = ((FilledBoundaryAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyFilledBoundaryAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "colorType") == 0)
        return FilledBoundaryAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::ColorBySingleColor));
    if(strcmp(name, "ColorByMultipleColors") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::ColorByMultipleColors));
    if(strcmp(name, "ColorByColorTable") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::ColorByColorTable));

    if(strcmp(name, "colorTableName") == 0)
        return FilledBoundaryAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "invertColorTable") == 0)
        return FilledBoundaryAttributes_GetInvertColorTable(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return FilledBoundaryAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return FilledBoundaryAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return FilledBoundaryAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "multiColor") == 0)
        return FilledBoundaryAttributes_GetMultiColor(self, NULL);
    if(strcmp(name, "boundaryNames") == 0)
        return FilledBoundaryAttributes_GetBoundaryNames(self, NULL);
    if(strcmp(name, "opacity") == 0)
        return FilledBoundaryAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "wireframe") == 0)
        return FilledBoundaryAttributes_GetWireframe(self, NULL);
    if(strcmp(name, "drawInternal") == 0)
        return FilledBoundaryAttributes_GetDrawInternal(self, NULL);
    if(strcmp(name, "smoothingLevel") == 0)
        return FilledBoundaryAttributes_GetSmoothingLevel(self, NULL);
    if(strcmp(name, "cleanZonesOnly") == 0)
        return FilledBoundaryAttributes_GetCleanZonesOnly(self, NULL);
    if(strcmp(name, "mixedColor") == 0)
        return FilledBoundaryAttributes_GetMixedColor(self, NULL);
    if(strcmp(name, "pointSize") == 0)
        return FilledBoundaryAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "pointType") == 0)
        return FilledBoundaryAttributes_GetPointType(self, NULL);
    if(strcmp(name, "Box") == 0)
        return PyInt_FromLong(long(Box));
    if(strcmp(name, "Axis") == 0)
        return PyInt_FromLong(long(Axis));
    if(strcmp(name, "Icosahedron") == 0)
        return PyInt_FromLong(long(Icosahedron));
    if(strcmp(name, "Octahedron") == 0)
        return PyInt_FromLong(long(Octahedron));
    if(strcmp(name, "Tetrahedron") == 0)
        return PyInt_FromLong(long(Tetrahedron));
    if(strcmp(name, "SphereGeometry") == 0)
        return PyInt_FromLong(long(SphereGeometry));
    if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(Point));
    if(strcmp(name, "Sphere") == 0)
        return PyInt_FromLong(long(Sphere));

    if(strcmp(name, "pointSizeVarEnabled") == 0)
        return FilledBoundaryAttributes_GetPointSizeVarEnabled(self, NULL);
    if(strcmp(name, "pointSizeVar") == 0)
        return FilledBoundaryAttributes_GetPointSizeVar(self, NULL);
    if(strcmp(name, "pointSizePixels") == 0)
        return FilledBoundaryAttributes_GetPointSizePixels(self, NULL);

    // Try and handle legacy fields

    bool boundaryTypeFound = false;
    bool lineStyleFound = false;
    // boundaryType and it's possible enumerations
    if (strcmp(name, "boundaryType") == 0)
    {
        boundaryTypeFound = true;
    }
    else if (strcmp(name, "Domain") == 0)
    {
        boundaryTypeFound = true;
    }
    else if (strcmp(name, "Group") == 0)
    {
        boundaryTypeFound = true;
    }
    else if (strcmp(name, "Material") == 0)
    {
        boundaryTypeFound = true;
    }
    else if (strcmp(name, "Unknown") == 0)
    {
        boundaryTypeFound = true;
    }
    if (strcmp(name, "filledFlag") == 0)
    {
        fprintf(stdout, "filledFlag is no longer a valid FilledBoundary "
                       "attribute.\nIt's value is being ignored, please remove "
                       "it from your script.\n");
        return PyInt_FromLong(0L);
    }
    // lineStyle and it's possible enumerations
    else if (strcmp(name, "lineStyle") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "SOLID") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DASH") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DOT") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DOTDASH") == 0)
    {
        lineStyleFound = true;
    }
    if (boundaryTypeFound)
    {
        fprintf(stdout, "boundaryType is no longer a valid FilledBoundary "
                       "attribute.\nIt's value is being ignored, please remove "
                       "it from your script.\n");
        return PyInt_FromLong(0L);
    }
    if (lineStyleFound)
    {
        fprintf(stdout, "lineStyle is no longer a valid FilledBoundary "
                       "attribute.\nIt's value is being ignored, please remove "
                       "it from your script.\n");
        return PyInt_FromLong(0L);
    }
    return Py_FindMethod(PyFilledBoundaryAttributes_methods, self, name);
}

int
PyFilledBoundaryAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "colorType") == 0)
        obj = FilledBoundaryAttributes_SetColorType(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = FilledBoundaryAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "invertColorTable") == 0)
        obj = FilledBoundaryAttributes_SetInvertColorTable(self, tuple);
    else if(strcmp(name, "legendFlag") == 0)
        obj = FilledBoundaryAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = FilledBoundaryAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "singleColor") == 0)
        obj = FilledBoundaryAttributes_SetSingleColor(self, tuple);
    else if(strcmp(name, "multiColor") == 0)
        obj = FilledBoundaryAttributes_SetMultiColor(self, tuple);
    else if(strcmp(name, "boundaryNames") == 0)
        obj = FilledBoundaryAttributes_SetBoundaryNames(self, tuple);
    else if(strcmp(name, "opacity") == 0)
        obj = FilledBoundaryAttributes_SetOpacity(self, tuple);
    else if(strcmp(name, "wireframe") == 0)
        obj = FilledBoundaryAttributes_SetWireframe(self, tuple);
    else if(strcmp(name, "drawInternal") == 0)
        obj = FilledBoundaryAttributes_SetDrawInternal(self, tuple);
    else if(strcmp(name, "smoothingLevel") == 0)
        obj = FilledBoundaryAttributes_SetSmoothingLevel(self, tuple);
    else if(strcmp(name, "cleanZonesOnly") == 0)
        obj = FilledBoundaryAttributes_SetCleanZonesOnly(self, tuple);
    else if(strcmp(name, "mixedColor") == 0)
        obj = FilledBoundaryAttributes_SetMixedColor(self, tuple);
    else if(strcmp(name, "pointSize") == 0)
        obj = FilledBoundaryAttributes_SetPointSize(self, tuple);
    else if(strcmp(name, "pointType") == 0)
        obj = FilledBoundaryAttributes_SetPointType(self, tuple);
    else if(strcmp(name, "pointSizeVarEnabled") == 0)
        obj = FilledBoundaryAttributes_SetPointSizeVarEnabled(self, tuple);
    else if(strcmp(name, "pointSizeVar") == 0)
        obj = FilledBoundaryAttributes_SetPointSizeVar(self, tuple);
    else if(strcmp(name, "pointSizePixels") == 0)
        obj = FilledBoundaryAttributes_SetPointSizePixels(self, tuple);

    // Try and handle legacy fields
    if(obj == NULL)
    {
        if(strcmp(name, "filledFlag") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "boundaryType") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "lineStyle") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
FilledBoundaryAttributes_print(PyObject *v, FILE *fp, int flags)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)v;
    fprintf(fp, "%s", PyFilledBoundaryAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
FilledBoundaryAttributes_str(PyObject *v)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)v;
    return PyString_FromString(PyFilledBoundaryAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *FilledBoundaryAttributes_Purpose = "This class contains the plot attributes for the filled boundary plot.";
#else
static char *FilledBoundaryAttributes_Purpose = "This class contains the plot attributes for the filled boundary plot.";
#endif

//
// The type description structure
//
static PyTypeObject FilledBoundaryAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "FilledBoundaryAttributes",                    // tp_name
    sizeof(FilledBoundaryAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)FilledBoundaryAttributes_dealloc,  // tp_dealloc
    (printfunc)FilledBoundaryAttributes_print,     // tp_print
    (getattrfunc)PyFilledBoundaryAttributes_getattr, // tp_getattr
    (setattrfunc)PyFilledBoundaryAttributes_setattr, // tp_setattr
    (cmpfunc)FilledBoundaryAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)FilledBoundaryAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    FilledBoundaryAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static FilledBoundaryAttributes *defaultAtts = 0;
static FilledBoundaryAttributes *currentAtts = 0;

static PyObject *
NewFilledBoundaryAttributes(int useCurrent)
{
    FilledBoundaryAttributesObject *newObject;
    newObject = PyObject_NEW(FilledBoundaryAttributesObject, &FilledBoundaryAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new FilledBoundaryAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new FilledBoundaryAttributes(*defaultAtts);
    else
        newObject->data = new FilledBoundaryAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapFilledBoundaryAttributes(const FilledBoundaryAttributes *attr)
{
    FilledBoundaryAttributesObject *newObject;
    newObject = PyObject_NEW(FilledBoundaryAttributesObject, &FilledBoundaryAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (FilledBoundaryAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
FilledBoundaryAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewFilledBoundaryAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef FilledBoundaryAttributesMethods[] = {
    {"FilledBoundaryAttributes", FilledBoundaryAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *FilledBoundaryAttributesObserver = 0;

std::string
PyFilledBoundaryAttributes_GetLogString()
{
    std::string s("FilledBoundaryAtts = FilledBoundaryAttributes()\n");
    if(currentAtts != 0)
        s += PyFilledBoundaryAttributes_ToString(currentAtts, "FilledBoundaryAtts.");
    return s;
}

static void
PyFilledBoundaryAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("FilledBoundaryAtts = FilledBoundaryAttributes()\n");
        s += PyFilledBoundaryAttributes_ToString(currentAtts, "FilledBoundaryAtts.");
        cb(s);
    }
}

void
PyFilledBoundaryAttributes_StartUp(FilledBoundaryAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyFilledBoundaryAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(FilledBoundaryAttributesObserver == 0)
    {
        FilledBoundaryAttributesObserver = new ObserverToCallback(subj,
            PyFilledBoundaryAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyFilledBoundaryAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete FilledBoundaryAttributesObserver;
    FilledBoundaryAttributesObserver = 0;
}

PyMethodDef *
PyFilledBoundaryAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return FilledBoundaryAttributesMethods;
}

bool
PyFilledBoundaryAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &FilledBoundaryAttributesType);
}

FilledBoundaryAttributes *
PyFilledBoundaryAttributes_FromPyObject(PyObject *obj)
{
    FilledBoundaryAttributesObject *obj2 = (FilledBoundaryAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyFilledBoundaryAttributes_New()
{
    return NewFilledBoundaryAttributes(0);
}

PyObject *
PyFilledBoundaryAttributes_Wrap(const FilledBoundaryAttributes *attr)
{
    return WrapFilledBoundaryAttributes(attr);
}

void
PyFilledBoundaryAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    FilledBoundaryAttributesObject *obj2 = (FilledBoundaryAttributesObject *)obj;
    obj2->parent = parent;
}

// ****************************************************************************
//  Modifications:
//    Kathleen Bonnell, Fri Jul 18 13:49:42 PDT 2003
//    Make defaultAtts point to the passed atts directly.
//
// ****************************************************************************

void
PyFilledBoundaryAttributes_SetDefaults(const FilledBoundaryAttributes *atts)
{
    defaultAtts = const_cast<FilledBoundaryAttributes*>(atts);
}

