// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  FilledBoundaryScriptingPluginInfo.C
// ************************************************************************* //
#include <PyFilledBoundaryAttributes.h>
#include <FilledBoundaryPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(FilledBoundary,Scripting)

// ****************************************************************************
// Method: FilledBoundaryScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
FilledBoundaryScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyFilledBoundaryAttributes_StartUp((FilledBoundaryAttributes *)subj, data);
}

// ****************************************************************************
// Method: FilledBoundaryScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
FilledBoundaryScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyFilledBoundaryAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: FilledBoundaryScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is FilledBoundary plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FilledBoundaryScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyFilledBoundaryAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: FilledBoundaryScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
FilledBoundaryScriptingPluginInfo::GetLogString()
{
    std::string s(PyFilledBoundaryAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: FilledBoundaryScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
FilledBoundaryScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyFilledBoundaryAttributes_SetDefaults((const FilledBoundaryAttributes *)atts);
}
