// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: FilledBoundaryPluginInfo.C
// ****************************************************************************

#include <FilledBoundaryPluginInfo.h>
#include <FilledBoundaryAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(FilledBoundary,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(FilledBoundary,General)

// ****************************************************************************
//  Method: FilledBoundaryGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
FilledBoundaryGeneralPluginInfo::GetName() const
{
    return "FilledBoundary";
}

// ****************************************************************************
//  Method: FilledBoundaryGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
FilledBoundaryGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: FilledBoundaryGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
FilledBoundaryGeneralPluginInfo::GetID() const
{
    return "FilledBoundary_1.0";
}
// ****************************************************************************
//  Method: FilledBoundaryGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
FilledBoundaryGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
