// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: FilledBoundaryCommonPluginInfo.C
// ****************************************************************************

#include <FilledBoundaryPluginInfo.h>
#include <FilledBoundaryAttributes.h>

// ****************************************************************************
//  Method: FilledBoundaryCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
FilledBoundaryCommonPluginInfo::AllocAttributes()
{
    return new FilledBoundaryAttributes;
}

// ****************************************************************************
//  Method: FilledBoundaryCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a FilledBoundary attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
FilledBoundaryCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((FilledBoundaryAttributes *) to) = *((FilledBoundaryAttributes *) from);
}

// ****************************************************************************
// Method: FilledBoundaryCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
FilledBoundaryCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MATERIAL;
}

