// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CurvePluginInfo.C
// ****************************************************************************

#include <CurvePluginInfo.h>
#include <CurveAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Curve,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Curve,General)

// ****************************************************************************
//  Method: CurveGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CurveGeneralPluginInfo::GetName() const
{
    return "Curve";
}

// ****************************************************************************
//  Method: CurveGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CurveGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: CurveGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CurveGeneralPluginInfo::GetID() const
{
    return "Curve_1.0";
}
// ****************************************************************************
//  Method: CurveGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
CurveGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
