// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ContourViewerEnginePluginInfo.C
// ****************************************************************************

#include <ContourPluginInfo.h>
#include <avtContourPlot.h>
#include <ContourAttributes.h>

//
// Storage for static data elements.
//
ContourAttributes *ContourViewerEnginePluginInfo::clientAtts = NULL;
ContourAttributes *ContourViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ContourViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:28 PST 2004
//
// ****************************************************************************
void
ContourViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (ContourViewerEnginePluginInfo::clientAtts == NULL)
    {
        ContourViewerEnginePluginInfo::clientAtts  = new ContourAttributes;
        ContourViewerEnginePluginInfo::defaultAtts = new ContourAttributes;
    }

    InitializeDefaultPalette(clientAtts);
    InitializeDefaultPalette(defaultAtts);
}


// ****************************************************************************
//  Method: ContourViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ContourViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ContourViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ContourViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ContourViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ContourViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ContourAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ContourViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ContourViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ContourAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ContourViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
ContourViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtContourPlot;
}

// ****************************************************************************
//  Method: ContourViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:28 PST 2004
//
//  Modifications:
//    Brad Whitlock, Fri Nov 22 14:06:17 PST 2002
//    Copy over the new plot's defaultPalette with the active discrete
//    palette from avtColorTables.
//
//    Brad Whitlock, Fri Mar 26 15:26:25 PST 2004
//    Changed the method interface.
//
// ****************************************************************************

void
ContourViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    ContourAttributes *contour = (ContourAttributes *)atts;
    *contour = *defaultAtts;

    // Set the defaultPalette for the plot.
    InitializeDefaultPalette(contour);
}

// ****************************************************************************
//  Method: ContourViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ContourViewerEnginePluginInfo::GetMenuName() const
{
    return "Contour";
}

// ****************************************************************************
// Method: ContourViewerEnginePluginInfo::InitializeDefaultPalette
//
// Purpose:
//   Initializes the default palette in the contour attributes using the
//   default discrete color table.
//
// Arguments:
//   contour : The ContourAttributes to initialize.
//
// Programmer: Brad Whitlock
// Creation:   Mon Dec 9 13:12:27 PST 2002
//
// Modifications:
//   Brad Whitlock, Wed Oct 22 16:42:08 PST 2003
//   I changed the code so if we're in multicolor mode, the default palette
//   does not get overwritten unless it is empty.
//
// ****************************************************************************
#include <avtColorTables.h>
#include <ColorTableAttributes.h>
void
ContourViewerEnginePluginInfo::InitializeDefaultPalette(ContourAttributes *contour)
{
    // Copy over the contour's defaultPalette with the default discrete
    // color table from avtColorTable.
    if(contour->GetColorType() != ContourAttributes::ColorByMultipleColors ||
       contour->GetDefaultPalette().GetNumControlPoints() < 1)
    {
        avtColorTables *ct = avtColorTables::Instance();
        ColorTableAttributes *ctAtts = ct->GetColorTables();
        int i = ctAtts->GetColorTableIndex(ct->GetDefaultDiscreteColorTable());
        if(i != -1)
        {
            contour->SetDefaultPalette(ctAtts->operator[](i));
        }
    }
}

