// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ContourScriptingPluginInfo.C
// ************************************************************************* //
#include <PyContourAttributes.h>
#include <ContourPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Contour,Scripting)

// ****************************************************************************
// Method: ContourScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ContourScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyContourAttributes_StartUp((ContourAttributes *)subj, data);
}

// ****************************************************************************
// Method: ContourScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ContourScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyContourAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ContourScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Contour plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ContourScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyContourAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ContourScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ContourScriptingPluginInfo::GetLogString()
{
    std::string s(PyContourAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ContourScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ContourScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyContourAttributes_SetDefaults((const ContourAttributes *)atts);
}
