// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ContourPluginInfo.C
// ****************************************************************************

#include <ContourPluginInfo.h>
#include <ContourAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Contour,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Contour,General)

// ****************************************************************************
//  Method: ContourGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ContourGeneralPluginInfo::GetName() const
{
    return "Contour";
}

// ****************************************************************************
//  Method: ContourGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ContourGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ContourGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ContourGeneralPluginInfo::GetID() const
{
    return "Contour_1.0";
}
// ****************************************************************************
//  Method: ContourGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ContourGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
