// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  BoundaryScriptingPluginInfo.C
// ************************************************************************* //
#include <PyBoundaryAttributes.h>
#include <BoundaryPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Boundary,Scripting)

// ****************************************************************************
// Method: BoundaryScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
BoundaryScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyBoundaryAttributes_StartUp((BoundaryAttributes *)subj, data);
}

// ****************************************************************************
// Method: BoundaryScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
BoundaryScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyBoundaryAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: BoundaryScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Boundary plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoundaryScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyBoundaryAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: BoundaryScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
BoundaryScriptingPluginInfo::GetLogString()
{
    std::string s(PyBoundaryAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: BoundaryScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
BoundaryScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyBoundaryAttributes_SetDefaults((const BoundaryAttributes *)atts);
}
