// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtZoneDumpFilter.h
// ************************************************************************* //

#ifndef AVT_ZoneDump_FILTER_H
#define AVT_ZoneDump_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <ZoneDumpAttributes.h>

#include <string>
#include <vector>

class vtkDataSet;


// ****************************************************************************
//  Class: avtZoneDumpFilter
//
//  Purpose:
//      A plugin operator for ZoneDump.
//
//  Programmer: harrison37 -- generated by xml2avt
//  Creation:   Tue Mar 13 09:00:34 PDT 2007
//
//  Modifications:
//    Cyrus Harrison, Mon Apr 30 10:51:03 PDT 2007
//    Fixed spelling mistake.
//
//    Eric Brugger, Tue Aug 19 09:53:03 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtZoneDumpFilter : public avtPluginDataTreeIterator
{
  public:
                         avtZoneDumpFilter();
    virtual             ~avtZoneDumpFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtZoneDumpFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Zone Dump"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:

    // ************************************************************************
    //  Class: avtZoneDumpFilter::ZoneInfo
    //
    //  Purpose:
    //      Helper that holds zone info.
    //
    //  Programmer: Cyrus Harrison
    //  Creation:   April 2, 2007
    //
    // ************************************************************************
    class ZoneInfo
    {
      public:
                   ZoneInfo();
                   ZoneInfo(int g, int d, int z,
                            int i, int j, int k,
                            float val);

        virtual   ~ZoneInfo();

        void       Print(ostream &os, const std::string &sep = " ") const;

        void       Pack(unsigned char *);
        void       Unpack(unsigned char *);

        bool       operator==(const ZoneInfo &b);

        static int PackedSize()
                    { return sizeof(int) *6 + sizeof(float); }

        int        groupId;
        int        domainId;
        int        zone;
        int        i, j, k;
        float      value;
    };

    ZoneDumpAttributes   atts;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual avtContract_p ModifyContract
                                 (avtContract_p contract);

    void                  PreExecute();
    void                  PostExecute();

    void                  GetOriginalLogicalIndices(vtkDataSet *ds,
                                                   int zone,
                                                   int ijk[3]);
    void                  SaveOutput(const std::string &, std::vector<ZoneInfo> &);

    std::vector<ZoneInfo>      zones;

};


#endif
