// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef ZONEDUMPATTRIBUTES_H
#define ZONEDUMPATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ZoneDumpAttributes
//
// Purpose:
//    Zone Dump Control
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class ZoneDumpAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ZoneDumpAttributes();
    ZoneDumpAttributes(const ZoneDumpAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ZoneDumpAttributes(private_tmfs_t tmfs);
    ZoneDumpAttributes(const ZoneDumpAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ZoneDumpAttributes();

    virtual ZoneDumpAttributes& operator = (const ZoneDumpAttributes &obj);
    virtual bool operator == (const ZoneDumpAttributes &obj) const;
    virtual bool operator != (const ZoneDumpAttributes &obj) const;
private:
    void Init();
    void Copy(const ZoneDumpAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectVariable();
    void SelectOutputFile();

    // Property setting methods
    void SetVariable(const std::string &variable_);
    void SetLowerBound(double lowerBound_);
    void SetUpperBound(double upperBound_);
    void SetOutputFile(const std::string &outputFile_);
    void SetEnabled(bool enabled_);

    // Property getting methods
    const std::string &GetVariable() const;
          std::string &GetVariable();
    double            GetLowerBound() const;
    double            GetUpperBound() const;
    const std::string &GetOutputFile() const;
          std::string &GetOutputFile();
    bool              GetEnabled() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_variable = 0,
        ID_lowerBound,
        ID_upperBound,
        ID_outputFile,
        ID_enabled,
        ID__LAST
    };

private:
    std::string variable;
    double      lowerBound;
    double      upperBound;
    std::string outputFile;
    bool        enabled;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define ZONEDUMPATTRIBUTES_TMFS "sddsb"

#endif
