// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TubeCommonPluginInfo.C
// ****************************************************************************

#include <TubePluginInfo.h>
#include <TubeAttributes.h>

// ****************************************************************************
//  Method: TubeCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
TubeCommonPluginInfo::AllocAttributes()
{
    return new TubeAttributes;
}

// ****************************************************************************
//  Method: TubeCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Tube attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TubeCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((TubeAttributes *) to) = *((TubeAttributes *) from);
}
