// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISTUBEWINDOW_H
#define QVISTUBEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class TubeAttributes;
class QLabel;
class QCheckBox;
class QLineEdit;
class QComboBox;
class QvisVariableButton;

// ****************************************************************************
// Class: QvisTubeWindow
//
// Purpose:
//    Defines QvisTubeWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
//   Hank Childs, Thu Oct 21 06:34:02 PDT 2010
//   Customize interface beyond what xml2window provides.
//
// ****************************************************************************

class QvisTubeWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisTubeWindow(const int type,
                         TubeAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisTubeWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void scaleByVarFlagChanged(bool val);
    void radiusTypeChanged(int val);
    void radiusProcessText();
    void scaleVariableChanged(const QString &varName);
    void finenessProcessText();
    void cappingChanged(bool val);
  private:
    QCheckBox *scaleByVarFlag;
    QLineEdit *radius;
    QComboBox *radiusType;
    QvisVariableButton *scaleVariable;
    QLineEdit *fineness;
    QCheckBox *capping;
    QLabel *radiusLabel;
    QLabel *scaleVariableLabel;
    QLabel *finenessLabel;

    TubeAttributes *atts;
};



#endif
