// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtTriangulateRegularPointsFilter.h
// ************************************************************************* //

#ifndef AVT_TriangulateRegularPoints_FILTER_H
#define AVT_TriangulateRegularPoints_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <TriangulateRegularPointsAttributes.h>


// ****************************************************************************
//  Class: avtTriangulateRegularPointsFilter
//
//  Purpose:
//      A plugin operator for TriangulateRegularPoints.
//
//  Programmer: brugger1 -- generated by xml2avt
//  Creation:   Fri Jun 5 17:15:09 PST 2009
//
//  Modifications:
//    Eric Brugger, Tue Aug 19 09:41:21 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtTriangulateRegularPointsFilter : public avtPluginDataTreeIterator
{
  public:
                         avtTriangulateRegularPointsFilter();
    virtual             ~avtTriangulateRegularPointsFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtTriangulateRegularPointsFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Triangulate Regular Points"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    TriangulateRegularPointsAttributes   atts;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
};


#endif
