// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TriangulateRegularPointsViewerEnginePluginInfo.C
// ****************************************************************************

#include <TriangulateRegularPointsPluginInfo.h>
#include <TriangulateRegularPointsAttributes.h>

//
// Storage for static data elements.
//
TriangulateRegularPointsAttributes *TriangulateRegularPointsViewerEnginePluginInfo::clientAtts = NULL;
TriangulateRegularPointsAttributes *TriangulateRegularPointsViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  TriangulateRegularPointsViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
TriangulateRegularPointsViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (TriangulateRegularPointsViewerEnginePluginInfo::clientAtts == NULL)
    {
        TriangulateRegularPointsViewerEnginePluginInfo::clientAtts  = new TriangulateRegularPointsAttributes;
        TriangulateRegularPointsViewerEnginePluginInfo::defaultAtts = new TriangulateRegularPointsAttributes;
    }
}

// ****************************************************************************
//  Method: TriangulateRegularPointsViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
TriangulateRegularPointsViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: TriangulateRegularPointsViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
TriangulateRegularPointsViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: TriangulateRegularPointsViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TriangulateRegularPointsViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(TriangulateRegularPointsAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: TriangulateRegularPointsViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TriangulateRegularPointsViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(TriangulateRegularPointsAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: TriangulateRegularPointsViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TriangulateRegularPointsViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(TriangulateRegularPointsAttributes*)atts = *defaultAtts;
    else
        *(TriangulateRegularPointsAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: TriangulateRegularPointsViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TriangulateRegularPointsViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: TriangulateRegularPointsViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TriangulateRegularPointsViewerEnginePluginInfo::GetMenuName() const
{
    return "Triangulate Regular Points";
}

