// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TriangulateRegularPointsCommonPluginInfo.C
// ****************************************************************************

#include <TriangulateRegularPointsPluginInfo.h>
#include <TriangulateRegularPointsAttributes.h>

// ****************************************************************************
//  Method: TriangulateRegularPointsCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
TriangulateRegularPointsCommonPluginInfo::AllocAttributes()
{
    return new TriangulateRegularPointsAttributes;
}

// ****************************************************************************
//  Method: TriangulateRegularPointsCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a TriangulateRegularPoints attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TriangulateRegularPointsCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((TriangulateRegularPointsAttributes *) to) = *((TriangulateRegularPointsAttributes *) from);
}
