// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISTRIANGULATEREGULARPOINTSWINDOW_H
#define QVISTRIANGULATEREGULARPOINTSWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class TriangulateRegularPointsAttributes;
class QLabel;
class QCheckBox;
class QLineEdit;

// ****************************************************************************
// Class: QvisTriangulateRegularPointsWindow
//
// Purpose:
//    Defines QvisTriangulateRegularPointsWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisTriangulateRegularPointsWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisTriangulateRegularPointsWindow(const int type,
                         TriangulateRegularPointsAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisTriangulateRegularPointsWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void useXGridSpacingChanged(bool val);
    void xGridSpacingProcessText();
    void useYGridSpacingChanged(bool val);
    void yGridSpacingProcessText();
  private:
    QCheckBox *useXGridSpacing;
    QLineEdit *xGridSpacing;
    QCheckBox *useYGridSpacing;
    QLineEdit *yGridSpacing;
    QLabel *xGridSpacingLabel;
    QLabel *yGridSpacingLabel;

    TriangulateRegularPointsAttributes *atts;
};



#endif
