// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  TransformScriptingPluginInfo.C
// ************************************************************************* //
#include <PyTransformAttributes.h>
#include <TransformPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Transform,Scripting)

// ****************************************************************************
// Method: TransformScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
TransformScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyTransformAttributes_StartUp((TransformAttributes *)subj, data);
}

// ****************************************************************************
// Method: TransformScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
TransformScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyTransformAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: TransformScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Transform plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
TransformScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyTransformAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: TransformScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
TransformScriptingPluginInfo::GetLogString()
{
    std::string s(PyTransformAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: TransformScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
TransformScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyTransformAttributes_SetDefaults((const TransformAttributes *)atts);
}
