// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <ToroidalPoloidalProjection.h>
#include <DataNode.h>

//
// Enum conversion methods for ToroidalPoloidalProjection::CentroidSource
//

static const char *CentroidSource_strings[] = {
"Manual", "Auto"};

std::string
ToroidalPoloidalProjection::CentroidSource_ToString(ToroidalPoloidalProjection::CentroidSource t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return CentroidSource_strings[index];
}

std::string
ToroidalPoloidalProjection::CentroidSource_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return CentroidSource_strings[index];
}

bool
ToroidalPoloidalProjection::CentroidSource_FromString(const std::string &s, ToroidalPoloidalProjection::CentroidSource &val)
{
    val = ToroidalPoloidalProjection::Manual;
    for(int i = 0; i < 2; ++i)
    {
        if(s == CentroidSource_strings[i])
        {
            val = (CentroidSource)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::ToroidalPoloidalProjection
//
// Purpose:
//   Init utility for the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void ToroidalPoloidalProjection::Init()
{
    R0 = 1.5;
    r = 0.2;
    centroidSource = Manual;
    centroid[0] = 0;
    centroid[1] = 0;
    centroid[2] = 0;
    project2D = true;

    ToroidalPoloidalProjection::SelectAll();
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::ToroidalPoloidalProjection
//
// Purpose:
//   Copy utility for the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void ToroidalPoloidalProjection::Copy(const ToroidalPoloidalProjection &obj)
{
    R0 = obj.R0;
    r = obj.r;
    centroidSource = obj.centroidSource;
    centroid[0] = obj.centroid[0];
    centroid[1] = obj.centroid[1];
    centroid[2] = obj.centroid[2];

    project2D = obj.project2D;

    ToroidalPoloidalProjection::SelectAll();
}

// Type map format string
const char *ToroidalPoloidalProjection::TypeMapFormatString = TOROIDALPOLOIDALPROJECTION_TMFS;
const AttributeGroup::private_tmfs_t ToroidalPoloidalProjection::TmfsStruct = {TOROIDALPOLOIDALPROJECTION_TMFS};


// ****************************************************************************
// Method: ToroidalPoloidalProjection::ToroidalPoloidalProjection
//
// Purpose:
//   Default constructor for the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ToroidalPoloidalProjection::ToroidalPoloidalProjection() :
    AttributeSubject(ToroidalPoloidalProjection::TypeMapFormatString)
{
    ToroidalPoloidalProjection::Init();
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::ToroidalPoloidalProjection
//
// Purpose:
//   Constructor for the derived classes of ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ToroidalPoloidalProjection::ToroidalPoloidalProjection(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    ToroidalPoloidalProjection::Init();
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::ToroidalPoloidalProjection
//
// Purpose:
//   Copy constructor for the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ToroidalPoloidalProjection::ToroidalPoloidalProjection(const ToroidalPoloidalProjection &obj) :
    AttributeSubject(ToroidalPoloidalProjection::TypeMapFormatString)
{
    ToroidalPoloidalProjection::Copy(obj);
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::ToroidalPoloidalProjection
//
// Purpose:
//   Copy constructor for derived classes of the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ToroidalPoloidalProjection::ToroidalPoloidalProjection(const ToroidalPoloidalProjection &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    ToroidalPoloidalProjection::Copy(obj);
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::~ToroidalPoloidalProjection
//
// Purpose:
//   Destructor for the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ToroidalPoloidalProjection::~ToroidalPoloidalProjection()
{
    // nothing here
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::operator =
//
// Purpose:
//   Assignment operator for the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ToroidalPoloidalProjection&
ToroidalPoloidalProjection::operator = (const ToroidalPoloidalProjection &obj)
{
    if (this == &obj) return *this;

    ToroidalPoloidalProjection::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::operator ==
//
// Purpose:
//   Comparison operator == for the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ToroidalPoloidalProjection::operator == (const ToroidalPoloidalProjection &obj) const
{
    // Compare the centroid arrays.
    bool centroid_equal = true;
    for(int i = 0; i < 3 && centroid_equal; ++i)
        centroid_equal = (centroid[i] == obj.centroid[i]);

    // Create the return value
    return ((R0 == obj.R0) &&
            (r == obj.r) &&
            (centroidSource == obj.centroidSource) &&
            centroid_equal &&
            (project2D == obj.project2D));
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::operator !=
//
// Purpose:
//   Comparison operator != for the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ToroidalPoloidalProjection::operator != (const ToroidalPoloidalProjection &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::TypeName
//
// Purpose:
//   Type name method for the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
ToroidalPoloidalProjection::TypeName() const
{
    return "ToroidalPoloidalProjection";
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ToroidalPoloidalProjection::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ToroidalPoloidalProjection *tmp = (const ToroidalPoloidalProjection *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
ToroidalPoloidalProjection::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ToroidalPoloidalProjection(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::NewInstance
//
// Purpose:
//   NewInstance method for the ToroidalPoloidalProjection class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
ToroidalPoloidalProjection::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ToroidalPoloidalProjection(*this);
    else
        retval = new ToroidalPoloidalProjection;

    return retval;
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ToroidalPoloidalProjection::SelectAll()
{
    Select(ID_R0,             (void *)&R0);
    Select(ID_r,              (void *)&r);
    Select(ID_centroidSource, (void *)&centroidSource);
    Select(ID_centroid,       (void *)centroid, 3);
    Select(ID_project2D,      (void *)&project2D);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ToroidalPoloidalProjection::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ToroidalPoloidalProjection::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ToroidalPoloidalProjection defaultObject;
    bool addToParent = false;
    // Create a node for ToroidalPoloidalProjection.
    DataNode *node = new DataNode("ToroidalPoloidalProjection");

    if(completeSave || !FieldsEqual(ID_R0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("R0", R0));
    }

    if(completeSave || !FieldsEqual(ID_r, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("r", r));
    }

    if(completeSave || !FieldsEqual(ID_centroidSource, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("centroidSource", CentroidSource_ToString(centroidSource)));
    }

    if(completeSave || !FieldsEqual(ID_centroid, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("centroid", centroid, 3));
    }

    if(completeSave || !FieldsEqual(ID_project2D, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("project2D", project2D));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ToroidalPoloidalProjection::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ToroidalPoloidalProjection");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("R0")) != 0)
        SetR0(node->AsDouble());
    if((node = searchNode->GetNode("r")) != 0)
        SetR(node->AsDouble());
    if((node = searchNode->GetNode("centroidSource")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetCentroidSource(CentroidSource(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            CentroidSource value;
            if(CentroidSource_FromString(node->AsString(), value))
                SetCentroidSource(value);
        }
    }
    if((node = searchNode->GetNode("centroid")) != 0)
        SetCentroid(node->AsDoubleArray());
    if((node = searchNode->GetNode("project2D")) != 0)
        SetProject2D(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ToroidalPoloidalProjection::SetR0(double R0_)
{
    R0 = R0_;
    Select(ID_R0, (void *)&R0);
}

void
ToroidalPoloidalProjection::SetR(double r_)
{
    r = r_;
    Select(ID_r, (void *)&r);
}

void
ToroidalPoloidalProjection::SetCentroidSource(ToroidalPoloidalProjection::CentroidSource centroidSource_)
{
    centroidSource = centroidSource_;
    Select(ID_centroidSource, (void *)&centroidSource);
}

void
ToroidalPoloidalProjection::SetCentroid(const double *centroid_)
{
    centroid[0] = centroid_[0];
    centroid[1] = centroid_[1];
    centroid[2] = centroid_[2];
    Select(ID_centroid, (void *)centroid, 3);
}

void
ToroidalPoloidalProjection::SetProject2D(bool project2D_)
{
    project2D = project2D_;
    Select(ID_project2D, (void *)&project2D);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

double
ToroidalPoloidalProjection::GetR0() const
{
    return R0;
}

double
ToroidalPoloidalProjection::GetR() const
{
    return r;
}

ToroidalPoloidalProjection::CentroidSource
ToroidalPoloidalProjection::GetCentroidSource() const
{
    return CentroidSource(centroidSource);
}

const double *
ToroidalPoloidalProjection::GetCentroid() const
{
    return centroid;
}

double *
ToroidalPoloidalProjection::GetCentroid()
{
    return centroid;
}

bool
ToroidalPoloidalProjection::GetProject2D() const
{
    return project2D;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ToroidalPoloidalProjection::SelectCentroid()
{
    Select(ID_centroid, (void *)centroid, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ToroidalPoloidalProjection::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
ToroidalPoloidalProjection::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_R0:             return "R0";
    case ID_r:              return "r";
    case ID_centroidSource: return "centroidSource";
    case ID_centroid:       return "centroid";
    case ID_project2D:      return "project2D";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
ToroidalPoloidalProjection::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_R0:             return FieldType_double;
    case ID_r:              return FieldType_double;
    case ID_centroidSource: return FieldType_enum;
    case ID_centroid:       return FieldType_doubleArray;
    case ID_project2D:      return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
ToroidalPoloidalProjection::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_R0:             return "double";
    case ID_r:              return "double";
    case ID_centroidSource: return "enum";
    case ID_centroid:       return "doubleArray";
    case ID_project2D:      return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ToroidalPoloidalProjection::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ToroidalPoloidalProjection::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ToroidalPoloidalProjection &obj = *((const ToroidalPoloidalProjection*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_R0:
        {  // new scope
        retval = (R0 == obj.R0);
        }
        break;
    case ID_r:
        {  // new scope
        retval = (r == obj.r);
        }
        break;
    case ID_centroidSource:
        {  // new scope
        retval = (centroidSource == obj.centroidSource);
        }
        break;
    case ID_centroid:
        {  // new scope
        // Compare the centroid arrays.
        bool centroid_equal = true;
        for(int i = 0; i < 3 && centroid_equal; ++i)
            centroid_equal = (centroid[i] == obj.centroid[i]);

        retval = centroid_equal;
        }
        break;
    case ID_project2D:
        {  // new scope
        retval = (project2D == obj.project2D);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

