// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISTOROIDALPOLOIDALPROJECTIONWINDOW_H
#define QVISTOROIDALPOLOIDALPROJECTIONWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class ToroidalPoloidalProjection;
class QLabel;
class QCheckBox;
class QLineEdit;
class QButtonGroup;

// ****************************************************************************
// Class: QvisToroidalPoloidalProjectionWindow
//
// Purpose:
//    Defines QvisToroidalPoloidalProjectionWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisToroidalPoloidalProjectionWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisToroidalPoloidalProjectionWindow(const int type,
                         ToroidalPoloidalProjection *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisToroidalPoloidalProjectionWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
//     void R0ProcessText();
//     void rProcessText();
    void centroidSourceChanged(int val);
    void centroidProcessText();
    void project2DChanged(bool val);
  private:
//     QLineEdit *R0;
//     QLineEdit *r;
    QWidget      *centroidSource;
    QButtonGroup *centroidSourceButtonGroup;
    QLineEdit *centroid;
    QCheckBox *project2D;
//     QLabel *R0Label;
//     QLabel *rLabel;
    QLabel *centroidSourceLabel;
    QLabel *centroidLabel;

    ToroidalPoloidalProjection *atts;
};



#endif
