// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ThresholdViewerEnginePluginInfo.C
// ****************************************************************************

#include <ThresholdPluginInfo.h>
#include <ThresholdAttributes.h>

//
// Storage for static data elements.
//
ThresholdAttributes *ThresholdViewerEnginePluginInfo::clientAtts = NULL;
ThresholdAttributes *ThresholdViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ThresholdViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
ThresholdViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (ThresholdViewerEnginePluginInfo::clientAtts == NULL)
    {
        ThresholdViewerEnginePluginInfo::clientAtts  = new ThresholdAttributes;
        ThresholdViewerEnginePluginInfo::defaultAtts = new ThresholdAttributes;
    }
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ThresholdViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ThresholdViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ThresholdViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ThresholdAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ThresholdViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ThresholdAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: mblair -- generated by xml2info
//  Creation:   Thu Mar 9 16:03:07 PST 2006
//
//   Modifications:
//
//     Mark Blair, Thu Mar  9 18:25:00 PST 2006
//     Upgraded to support multiple threshold variables.
//
//     Mark Blair, Tue Aug  8 17:47:00 PDT 2006
//     Now accommodates an empty list of threshold variables; does pass-through.
//     Also checks for attribute consistency.
//
//     Mark Blair, Wed Sep  6 19:13:00 PDT 2006
//     Corrected bad policy: Was sometimes changing user's defaults explicitly.
//
//     Mark Blair, Thu Sep 28 12:07:05 PDT 2006
//     Accommodate old Threshold mode in CLI by supplying any missing default
//     attribute values if attributes are set up for a single threshold variable.
//
//     Mark Blair, Tue Oct  3 13:19:11 PDT 2006
//     Set attribute flag that indicates whether plot variable is a scalar.
//
// ****************************************************************************
#include <avtPlotMetaData.h>
#include <DebugStream.h>
void
ThresholdViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                                  const avtPlotMetaData &plot,
                                                  const bool fromDefault)
{
    if (fromDefault)
        *(ThresholdAttributes *)atts = *defaultAtts;
    else
        *(ThresholdAttributes *)atts = *clientAtts;

    ThresholdAttributes *initAtts = (ThresholdAttributes *)atts;

    initAtts->SupplyMissingDefaultsIfAppropriate();

    initAtts->SetDefaultVarName(plot.GetVariableName());
    initAtts->SetDefaultVarIsScalar(plot.GetVariableType() == AVT_SCALAR_VAR);

    UpdateOperatorAtts(initAtts, plot);
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ThresholdViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ThresholdViewerEnginePluginInfo::GetMenuName() const
{
    return "Threshold";
}

