// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyThresholdAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyThresholdAttributes
//
// Purpose:
//   This class contains attributes for the threshold operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ThresholdAttributes.
//
struct ThresholdAttributesObject
{
    PyObject_HEAD
    ThresholdAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewThresholdAttributes(int);

std::string
PyThresholdAttributes_ToString(const ThresholdAttributes *atts, const char *prefix)
{
    std::string str;

    str = PyThresholdOpAttributes_ToString(atts, prefix);

    return str;
}

static PyObject *
ThresholdAttributes_Notify(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}



PyMethodDef PyThresholdAttributes_methods[THRESHOLDATTRIBUTES_NMETH] = {
    {"Notify", ThresholdAttributes_Notify, METH_VARARGS},
    {NULL, NULL}
};

static void PyThresholdAttributes_ExtendSetGetMethodTable()
{
    static bool extended = false;
    if (extended) return;
    extended = true;

    int i = 0;
    while (PyThresholdAttributes_methods[i].ml_name)
        i++;
    int n = i;
    while (PyThresholdOpAttributes_methods[i-n+1].ml_name)
    {
        PyThresholdAttributes_methods[i] = PyThresholdOpAttributes_methods[i-n+1];
        i++;
    }

    PyMethodDef nullMethod = {NULL, NULL};
    PyThresholdAttributes_methods[i] = nullMethod;
}

//
// Type functions
//

static void
ThresholdAttributes_dealloc(PyObject *v)
{
   ThresholdAttributesObject *obj = (ThresholdAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ThresholdAttributes_compare(PyObject *v, PyObject *w)
{
    ThresholdAttributes *a = ((ThresholdAttributesObject *)v)->data;
    ThresholdAttributes *b = ((ThresholdAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyThresholdAttributes_getattr(PyObject *self, char *name)
{

    if(strcmp(name, "__methods__") != 0)
    {
        PyObject *retval = PyThresholdOpAttributes_getattr(self, name);
        if (retval) return retval;
    }

    PyThresholdAttributes_ExtendSetGetMethodTable();

    return Py_FindMethod(PyThresholdAttributes_methods, self, name);
}

int
PyThresholdAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    if (PyThresholdOpAttributes_setattr(self, name, args) != -1)
        return 0;
    else
        PyErr_Clear();

    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;


    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ThresholdAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)v;
    fprintf(fp, "%s", PyThresholdAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ThresholdAttributes_str(PyObject *v)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)v;
    return PyString_FromString(PyThresholdAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ThresholdAttributes_Purpose = "This class contains attributes for the threshold operator.";
#else
static char *ThresholdAttributes_Purpose = "This class contains attributes for the threshold operator.";
#endif

//
// The type description structure
//
static PyTypeObject ThresholdAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ThresholdAttributes",                    // tp_name
    sizeof(ThresholdAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ThresholdAttributes_dealloc,  // tp_dealloc
    (printfunc)ThresholdAttributes_print,     // tp_print
    (getattrfunc)PyThresholdAttributes_getattr, // tp_getattr
    (setattrfunc)PyThresholdAttributes_setattr, // tp_setattr
    (cmpfunc)ThresholdAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ThresholdAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ThresholdAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ThresholdAttributes *defaultAtts = 0;
static ThresholdAttributes *currentAtts = 0;

static PyObject *
NewThresholdAttributes(int useCurrent)
{
    ThresholdAttributesObject *newObject;
    newObject = PyObject_NEW(ThresholdAttributesObject, &ThresholdAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ThresholdAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ThresholdAttributes(*defaultAtts);
    else
        newObject->data = new ThresholdAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapThresholdAttributes(const ThresholdAttributes *attr)
{
    ThresholdAttributesObject *newObject;
    newObject = PyObject_NEW(ThresholdAttributesObject, &ThresholdAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ThresholdAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ThresholdAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewThresholdAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ThresholdAttributesMethods[] = {
    {"ThresholdAttributes", ThresholdAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ThresholdAttributesObserver = 0;

std::string
PyThresholdAttributes_GetLogString()
{
    std::string s("ThresholdAtts = ThresholdAttributes()\n");
    if(currentAtts != 0)
        s += PyThresholdAttributes_ToString(currentAtts, "ThresholdAtts.");
    return s;
}

static void
PyThresholdAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ThresholdAtts = ThresholdAttributes()\n");
        s += PyThresholdAttributes_ToString(currentAtts, "ThresholdAtts.");
        cb(s);
    }
}

void
PyThresholdAttributes_StartUp(ThresholdAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyThresholdAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ThresholdAttributesObserver == 0)
    {
        ThresholdAttributesObserver = new ObserverToCallback(subj,
            PyThresholdAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyThresholdAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ThresholdAttributesObserver;
    ThresholdAttributesObserver = 0;
}

PyMethodDef *
PyThresholdAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ThresholdAttributesMethods;
}

bool
PyThresholdAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ThresholdAttributesType);
}

ThresholdAttributes *
PyThresholdAttributes_FromPyObject(PyObject *obj)
{
    ThresholdAttributesObject *obj2 = (ThresholdAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyThresholdAttributes_New()
{
    return NewThresholdAttributes(0);
}

PyObject *
PyThresholdAttributes_Wrap(const ThresholdAttributes *attr)
{
    return WrapThresholdAttributes(attr);
}

void
PyThresholdAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ThresholdAttributesObject *obj2 = (ThresholdAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyThresholdAttributes_SetDefaults(const ThresholdAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ThresholdAttributes(*atts);
}

