// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ThreeSliceViewerEnginePluginInfo.C
// ****************************************************************************

#include <ThreeSlicePluginInfo.h>
#include <ThreeSliceAttributes.h>

//
// Storage for static data elements.
//
ThreeSliceAttributes *ThreeSliceViewerEnginePluginInfo::clientAtts = NULL;
ThreeSliceAttributes *ThreeSliceViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ThreeSliceViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
ThreeSliceViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (ThreeSliceViewerEnginePluginInfo::clientAtts == NULL)
    {
        ThreeSliceViewerEnginePluginInfo::clientAtts  = new ThreeSliceAttributes;
        ThreeSliceViewerEnginePluginInfo::defaultAtts = new ThreeSliceAttributes;
    }
}

// ****************************************************************************
//  Method: ThreeSliceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ThreeSliceViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ThreeSliceViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ThreeSliceViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ThreeSliceViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ThreeSliceViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ThreeSliceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ThreeSliceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ThreeSliceViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ThreeSliceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ThreeSliceViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ThreeSliceViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ThreeSliceAttributes*)atts = *defaultAtts;
    else
        *(ThreeSliceAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: ThreeSliceViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ThreeSliceViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: ThreeSliceViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ThreeSliceViewerEnginePluginInfo::GetMenuName() const
{
    return "ThreeSlice";
}

