// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: ThreeSliceAttributes
//
// Purpose:
//    This class contains attributes for the threeslice operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class ThreeSliceAttributes extends AttributeSubject implements Plugin
{
    private static int ThreeSliceAttributes_numAdditionalAtts = 4;

    public ThreeSliceAttributes()
    {
        super(ThreeSliceAttributes_numAdditionalAtts);

        x = 0;
        y = 0;
        z = 0;
        interactive = true;
    }

    public ThreeSliceAttributes(int nMoreFields)
    {
        super(ThreeSliceAttributes_numAdditionalAtts + nMoreFields);

        x = 0;
        y = 0;
        z = 0;
        interactive = true;
    }

    public ThreeSliceAttributes(ThreeSliceAttributes obj)
    {
        super(obj);

        x = obj.x;
        y = obj.y;
        z = obj.z;
        interactive = obj.interactive;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return ThreeSliceAttributes_numAdditionalAtts;
    }

    public boolean equals(ThreeSliceAttributes obj)
    {
        // Create the return value
        return ((x == obj.x) &&
                (y == obj.y) &&
                (z == obj.z) &&
                (interactive == obj.interactive));
    }

    public String GetName() { return "ThreeSlice"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetX(double x_)
    {
        x = x_;
        Select(0);
    }

    public void SetY(double y_)
    {
        y = y_;
        Select(1);
    }

    public void SetZ(double z_)
    {
        z = z_;
        Select(2);
    }

    public void SetInteractive(boolean interactive_)
    {
        interactive = interactive_;
        Select(3);
    }

    // Property getting methods
    public double  GetX() { return x; }
    public double  GetY() { return y; }
    public double  GetZ() { return z; }
    public boolean GetInteractive() { return interactive; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteDouble(x);
        if(WriteSelect(1, buf))
            buf.WriteDouble(y);
        if(WriteSelect(2, buf))
            buf.WriteDouble(z);
        if(WriteSelect(3, buf))
            buf.WriteBool(interactive);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetX(buf.ReadDouble());
            break;
        case 1:
            SetY(buf.ReadDouble());
            break;
        case 2:
            SetZ(buf.ReadDouble());
            break;
        case 3:
            SetInteractive(buf.ReadBool());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + doubleToString("x", x, indent) + "\n";
        str = str + doubleToString("y", y, indent) + "\n";
        str = str + doubleToString("z", z, indent) + "\n";
        str = str + boolToString("interactive", interactive, indent) + "\n";
        return str;
    }


    // Attributes
    private double  x;
    private double  y;
    private double  z;
    private boolean interactive;
}

