// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisThreeSliceWindow.h"

#include <ThreeSliceAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisThreeSliceWindow::QvisThreeSliceWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisThreeSliceWindow::QvisThreeSliceWindow(const int type,
                         ThreeSliceAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisThreeSliceWindow::~QvisThreeSliceWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisThreeSliceWindow::~QvisThreeSliceWindow()
{
}


// ****************************************************************************
// Method: QvisThreeSliceWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisThreeSliceWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    xLabel = new QLabel(tr("X"), central);
    mainLayout->addWidget(xLabel,0,0);
    x = new QLineEdit(central);
    connect(x, SIGNAL(returnPressed()),
            this, SLOT(xProcessText()));
    mainLayout->addWidget(x, 0,1);

    yLabel = new QLabel(tr("Y"), central);
    mainLayout->addWidget(yLabel,1,0);
    y = new QLineEdit(central);
    connect(y, SIGNAL(returnPressed()),
            this, SLOT(yProcessText()));
    mainLayout->addWidget(y, 1,1);

    zLabel = new QLabel(tr("Z"), central);
    mainLayout->addWidget(zLabel,2,0);
    z = new QLineEdit(central);
    connect(z, SIGNAL(returnPressed()),
            this, SLOT(zProcessText()));
    mainLayout->addWidget(z, 2,1);

    interactive = new QCheckBox(tr("Interactive"), central);
    connect(interactive, SIGNAL(toggled(bool)),
            this, SLOT(interactiveChanged(bool)));
    mainLayout->addWidget(interactive, 3,0);

}


// ****************************************************************************
// Method: QvisThreeSliceWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Kathleen Biagas, Thu Apr 9 07:19:54 MST 2015
//   Changed 'FloatToQString' DoubleToQString to reflect underlying data type.
//
// ****************************************************************************

void
QvisThreeSliceWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case ThreeSliceAttributes::ID_x:
            x->setText(DoubleToQString(atts->GetX()));
            break;
          case ThreeSliceAttributes::ID_y:
            y->setText(DoubleToQString(atts->GetY()));
            break;
          case ThreeSliceAttributes::ID_z:
            z->setText(DoubleToQString(atts->GetZ()));
            break;
          case ThreeSliceAttributes::ID_interactive:
            interactive->blockSignals(true);
            interactive->setChecked(atts->GetInteractive());
            interactive->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisThreeSliceWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//    Kathleen Biagas, Thu Apr  9 10:57:35 PDT 2015
//    Modified to use double, to reflect data type in atts.
//
// ****************************************************************************

void
QvisThreeSliceWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do x
    if(which_widget == ThreeSliceAttributes::ID_x || doAll)
    {
        double val;
        if(LineEditGetDouble(x, val))
            atts->SetX(val);
        else
        {
            ResettingError(tr("x"),
                DoubleToQString(atts->GetX()));
            atts->SetX(atts->GetX());
        }
    }

    // Do y
    if(which_widget == ThreeSliceAttributes::ID_y || doAll)
    {
        double val;
        if(LineEditGetDouble(y, val))
            atts->SetY(val);
        else
        {
            ResettingError(tr("y"),
                DoubleToQString(atts->GetY()));
            atts->SetY(atts->GetY());
        }
    }

    // Do z
    if(which_widget == ThreeSliceAttributes::ID_z || doAll)
    {
        double val;
        if(LineEditGetDouble(z, val))
            atts->SetZ(val);
        else
        {
            ResettingError(tr("z"),
                DoubleToQString(atts->GetZ()));
            atts->SetZ(atts->GetZ());
        }
    }

}


//
// Qt Slot functions
//


void
QvisThreeSliceWindow::xProcessText()
{
    GetCurrentValues(ThreeSliceAttributes::ID_x);
    Apply();
}


void
QvisThreeSliceWindow::yProcessText()
{
    GetCurrentValues(ThreeSliceAttributes::ID_y);
    Apply();
}


void
QvisThreeSliceWindow::zProcessText()
{
    GetCurrentValues(ThreeSliceAttributes::ID_z);
    Apply();
}


void
QvisThreeSliceWindow::interactiveChanged(bool val)
{
    atts->SetInteractive(val);
    SetUpdate(false);
    Apply();
}


