// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SurfaceNormalViewerEnginePluginInfo.C
// ****************************************************************************

#include <SurfaceNormalPluginInfo.h>
#include <SurfaceNormalAttributes.h>

//
// Storage for static data elements.
//
SurfaceNormalAttributes *SurfaceNormalViewerEnginePluginInfo::clientAtts = NULL;
SurfaceNormalAttributes *SurfaceNormalViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SurfaceNormalViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
SurfaceNormalViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (SurfaceNormalViewerEnginePluginInfo::clientAtts == NULL)
    {
        SurfaceNormalViewerEnginePluginInfo::clientAtts  = new SurfaceNormalAttributes;
        SurfaceNormalViewerEnginePluginInfo::defaultAtts = new SurfaceNormalAttributes;
    }
}

// ****************************************************************************
//  Method: SurfaceNormalViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SurfaceNormalViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SurfaceNormalViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SurfaceNormalViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SurfaceNormalViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SurfaceNormalViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SurfaceNormalAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SurfaceNormalViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SurfaceNormalViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SurfaceNormalAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SurfaceNormalViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SurfaceNormalViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(SurfaceNormalAttributes*)atts = *defaultAtts;
    else
        *(SurfaceNormalAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: SurfaceNormalViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SurfaceNormalViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: SurfaceNormalViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfaceNormalViewerEnginePluginInfo::GetMenuName() const
{
    return "SurfaceNormal";
}

