// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SurfaceNormalGUIPluginInfo.C
// ****************************************************************************

#include <SurfaceNormalPluginInfo.h>
#include <SurfaceNormalAttributes.h>
#include <QApplication>
#include <QvisSurfaceNormalWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(SurfaceNormal,GUI)

// ****************************************************************************
//  Method: SurfaceNormalGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
SurfaceNormalGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "SurfaceNormal"));
}


// ****************************************************************************
//  Method: SurfaceNormalGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
SurfaceNormalGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisSurfaceNormalWindow(type, (SurfaceNormalAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: SurfaceNormalGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <SurfaceNormal.xpm>
const char **
SurfaceNormalGUIPluginInfo::XPMIconData() const
{
    return SurfaceNormal_xpm;
}

