// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: SurfaceNormalAttributes
//
// Purpose:
//    Attributes for SurfaceNormal operator
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class SurfaceNormalAttributes extends AttributeSubject implements Plugin
{
    private static int SurfaceNormalAttributes_numAdditionalAtts = 1;

    // Enum values
    public final static int CENTERING_POINT = 0;
    public final static int CENTERING_CELL = 1;


    public SurfaceNormalAttributes()
    {
        super(SurfaceNormalAttributes_numAdditionalAtts);

        centering = CENTERING_POINT;
    }

    public SurfaceNormalAttributes(int nMoreFields)
    {
        super(SurfaceNormalAttributes_numAdditionalAtts + nMoreFields);

        centering = CENTERING_POINT;
    }

    public SurfaceNormalAttributes(SurfaceNormalAttributes obj)
    {
        super(obj);

        centering = obj.centering;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return SurfaceNormalAttributes_numAdditionalAtts;
    }

    public boolean equals(SurfaceNormalAttributes obj)
    {
        // Create the return value
        return ((centering == obj.centering));
    }

    public String GetName() { return "SurfaceNormal"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetCentering(int centering_)
    {
        centering = centering_;
        Select(0);
    }

    // Property getting methods
    public int GetCentering() { return centering; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(centering);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        SetCentering(buf.ReadInt());
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "centering = ";
        if(centering == CENTERING_POINT)
            str = str + "CENTERING_POINT";
        if(centering == CENTERING_CELL)
            str = str + "CENTERING_CELL";
        str = str + "\n";
        return str;
    }


    // Attributes
    private int centering;
}

