// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISSURFACENORMALWINDOW_H
#define QVISSURFACENORMALWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class SurfaceNormalAttributes;
class QLabel;
class QButtonGroup;

// ****************************************************************************
// Class: QvisSurfaceNormalWindow
//
// Purpose:
//    Defines QvisSurfaceNormalWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisSurfaceNormalWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisSurfaceNormalWindow(const int type,
                         SurfaceNormalAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisSurfaceNormalWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void centeringChanged(int val);
  private:
    QWidget      *centering;
    QButtonGroup *centeringButtonGroup;
    QLabel *centeringLabel;

    SurfaceNormalAttributes *atts;
};



#endif
