// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisSurfaceNormalWindow.h"

#include <SurfaceNormalAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QButtonGroup>
#include <QRadioButton>


// ****************************************************************************
// Method: QvisSurfaceNormalWindow::QvisSurfaceNormalWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisSurfaceNormalWindow::QvisSurfaceNormalWindow(const int type,
                         SurfaceNormalAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisSurfaceNormalWindow::~QvisSurfaceNormalWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisSurfaceNormalWindow::~QvisSurfaceNormalWindow()
{
}


// ****************************************************************************
// Method: QvisSurfaceNormalWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSurfaceNormalWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    centeringLabel = new QLabel(tr("Centering"), central);
    mainLayout->addWidget(centeringLabel,0,0);
    centering = new QWidget(central);
    centeringButtonGroup= new QButtonGroup(centering);
    QHBoxLayout *centeringLayout = new QHBoxLayout(centering);
    centeringLayout->setMargin(0);
    centeringLayout->setSpacing(10);
    QRadioButton *centeringCenteringPoint = new QRadioButton(tr("Point"), centering);
    centeringButtonGroup->addButton(centeringCenteringPoint,0);
    centeringLayout->addWidget(centeringCenteringPoint);
    QRadioButton *centeringCenteringCell = new QRadioButton(tr("Cell"), centering);
    centeringButtonGroup->addButton(centeringCenteringCell,1);
    centeringLayout->addWidget(centeringCenteringCell);
    connect(centeringButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(centeringChanged(int)));
    mainLayout->addWidget(centering, 0,1);

}


// ****************************************************************************
// Method: QvisSurfaceNormalWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSurfaceNormalWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case SurfaceNormalAttributes::ID_centering:
            centeringButtonGroup->blockSignals(true);
            if(centeringButtonGroup->button((int)atts->GetCentering()) != 0)
                centeringButtonGroup->button((int)atts->GetCentering())->setChecked(true);
            centeringButtonGroup->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisSurfaceNormalWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSurfaceNormalWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisSurfaceNormalWindow::centeringChanged(int val)
{
    if(val != atts->GetCentering())
    {
        atts->SetCentering(SurfaceNormalAttributes::Centering(val));
        SetUpdate(false);
        Apply();
    }
}


