// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  SurfCompPrepScriptingPluginInfo.C
// ************************************************************************* //
#include <PySurfCompPrepAttributes.h>
#include <SurfCompPrepPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(SurfCompPrep,Scripting)

// ****************************************************************************
// Method: SurfCompPrepScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SurfCompPrepScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PySurfCompPrepAttributes_StartUp((SurfCompPrepAttributes *)subj, data);
}

// ****************************************************************************
// Method: SurfCompPrepScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
SurfCompPrepScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySurfCompPrepAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SurfCompPrepScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is SurfCompPrep plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SurfCompPrepScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySurfCompPrepAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SurfCompPrepScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
SurfCompPrepScriptingPluginInfo::GetLogString()
{
    std::string s(PySurfCompPrepAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: SurfCompPrepScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SurfCompPrepScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySurfCompPrepAttributes_SetDefaults((const SurfCompPrepAttributes *)atts);
}
